#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <assert.h>
#include <sys/time.h>

#define YSIZE	287	/* 568 / 2 */

int ybar=0;

short colortable[1380*4];

extern void putline(int,int,int,int,int,int,void*,void*);
extern void putlinedup(int,int,int,int,int,int,void*,void*,void*);

void decode_fullframe(unsigned char *dest,
	unsigned char *src,int xsize, int xsize_src, int ysize, int dest_xsize)
{
    int y;
    short *p2;
    unsigned char *p1;
    int diff;
    int count;
    int xoffset=((xsize_src-xsize)*2) & ~3;

    ysize-=1;

	p2 = (short *) dest + (ybar * dest_xsize);
	p1 = src+xoffset+ (ybar * xsize_src*2);
	diff = 0;
	// verkleinern
	count=YSIZE;
	for (y=ybar; y<((YSIZE*2)-ybar); y++)
	{
	    count+=ysize;
	    if (count>=YSIZE*2) { 			// Ausgabe
		putline (0,0,0,y,y+32,xsize*2,p2,p1); 
		count-=YSIZE*2;
		p2+=dest_xsize;
	    }
	    p1+=xsize_src*2;
	}
	return;
}

void init_decode(void)
{
    int i;
    double f;
    double f1 = -1.56071095712045105;
    double f2 = 0.1047197551196597746;
    double f3 = 0.7058823529411764706;

    short *p;

    p = colortable;

    for (i=0;i<1380;i++) {
	f = (double)((i >> 2) - 344) * f1 - f2;
	*p = cos(f) * 8192.0;
	*(p+2) = sin(f) * 8192.0 * f3;
	*(p+1) = -sin(f) * 8192.0;
	*(p+3) = cos(f) * 8192.0 * f3;
	if ( i & 2 ) {
	    *(p+2) = -*(p+2);
	    *(p+3) = -*(p+3);
	}
	if ( i & 1 ) {
	    *(p+1) = -*(p+1);
	    *(p+3) = -*(p+3);
	}
	p += 4;
    }
}

