module ClassParsing where

{-
 - succeed is like return in a Parsing monad, it just
 - lifts its argument into the Parsing class.
 -
 - symbol read a specifed symbol from the symbol class.
 - 
 - <?> allows a failure/error message to be specified,
 - along with a possible alternative.

 - <*> joins two parsers
 - <|> joins two alternative parsers
 - <=> lets you name a parse rule
 -}

-- ==============================================================
-- CLASSES
-- ==============================================================

-- Class for parsers, with operations:
--    <?> :
--    <|> : choice
--    <*> : sequence

{- infixl 2 <?> ; -}
infixl 3 <|> ; infixl 4 <*>
infixl 0 <=>
infixl 0 <==>

class (Eq s,Ord s,Enum s) => Symbol s  where
	char   :: Parsing p => Char   -> p s s
	string :: Parsing p => String -> p s s

	char   = symbol . char_
	string = symbol . string_

	char_   :: Char -> s
	string_ :: String -> s

	char_ = error "no mapping for this char"
	string_ = error "no mapping for this string"

	getToken :: state -> Maybe (s,state)

class Parsing p where
  succeed   :: Symbol s => a -> p s a
  symbol    :: Symbol s => s -> p s s
 -- (<?>)   :: Symbol s => p s a      -> (a,String) -> p s a
  (<|>)     :: Symbol s => p s a      ->  p s a -> p s a
  (<*>)     :: Symbol s => p s (b->a) ->  p s b -> p s a
  (<=>)     :: Symbol s => String     ->  p s a -> p s a
  (<==>)    :: Symbol s => String     -> (p s a -> p s a) -> p s a

--  p <?> _  = p

  nm <=> a = a
  nm <==> f = f (nm <==> f)

infixl 4  <$>, <$->, <*->, <-*>, <**>, <??>
infixl 2 `opt`

opt    :: (Parsing p,Symbol s) =>  p s a -> a          -> p s a
(<$>)  :: (Parsing p,Symbol s) => (b->a) -> p s b      -> p s a
(<$->) :: (Parsing p,Symbol s) =>     a  -> p s b      -> p s a
(<*->) :: (Parsing p,Symbol s) => p s a  -> p s b      -> p s a
(<-*>) :: (Parsing p,Symbol s) => p s a  -> p s b      -> p s b
(<**>) :: (Parsing p,Symbol s) => p s b  -> p s (b->a) -> p s a
(<??>) :: (Parsing p,Symbol s) => p s b  -> p s (b->b) -> p s b

-- definitions of derived parser combinators

p `opt` v = p <|> succeed v
f <$> p   = succeed f <*> p
f <$-> p  = const f <$> p
p <*-> q  = (\ x _ -> x) <$> p <*> q
p <-*> q  = (\ _ x -> x) <$> p <*> q
p <**> q  = (\ x f -> f x) <$> p <*> q
p <??> q  = (\ x f -> f x) <$> p <*> (q `opt` id)

pFoldr         alg@(op,e)     p = pfm where pfm = (op <$> p <*> pfm) `opt` e
pFoldrSep      alg@(op,e) sep p = op <$> p <*> pFoldr alg (sep <-*> p) 
pFoldrPrefixed alg@(op,e) c   p = pFoldr alg (c <-*> p)
 
--pMany   --> Use pList instead
pList           p = pFoldr         ((:),[])   p
pListSep      s p = pFoldrSep      ((:),[]) s p
pListPrefixed c p = pFoldrPrefixed ((:),[]) c p

pSome p       =  pSomep where pSomep = (:) <$> p <*> pList p
pChainr op x =  r where r = x <**> (flip <$> op <*> r `opt` id)
pChainl op x =  f <$> x <*> pList (flip <$> op <*> x) 
               where
                 f x [] = x
                 f x (func:rest) = f (func x) rest

pPacked l x r
  =   l <-*>  x <*->  r

pOptional :: (Parsing p, Symbol s) => p s a -> p s (Maybe a)
pOptional p = (Just <$> p) `opt` Nothing

{-
 - One of takes a non-zero list of parsers,
 - and returns a parser that does *one* of
 - the parsers.
 -}

pOneOf :: (Parsing p,Symbol s) => [p s a] -> p s a
pOneOf = foldl1 (<|>)

{-

infixl 4 <$> ; infixl 2 `opt`
infixl 4 <#> ; infixl 4 <.>

(<.>)  :: (Parsing p,Symbol s) => p s a -> p s b -> p s a
f <.> p = const <$> f <*> p

(<$>) :: (Parsing p, Symbol s) => (b->a) -> p s b -> p s a
f <$> p = succeed f <*> p

(<#>) :: (Parsing p, Symbol s) => a -> p s b -> p s a
f <#> p = succeed f <.> p

opt :: (Parsing p, Symbol s) => p s a -> a -> p s a
p `opt` v = p <|> succeed v

optional :: (Parsing p, Symbol s) => p s a -> p s (Maybe a)
optional p = (Just <$> p) <|> succeed Nothing

-- many   : (p)*
-- chainr : (operand operator)*
-- chainl : (operator operand)*

many :: (Parsing p, Symbol s) => p s a -> p s [a]
many p = 
  "many" <==> (\ r -> (\a as -> a:as) <$> p <*> r `opt` [])

chainr :: (Parsing p, Symbol s) => p s a -> p s (a -> a -> a) -> p s a
chainr x op = (\x f -> f x) <$> x <*> f where
  f = (\op x -> (`op` x)) <$> op <*> chainr x op `opt` id

-- chainl :: (Parsing p, Symbol s) => p s (a -> a -> a) -> p s a -> p s a
-- chainl op x =

{-
 - One of takes a non-zero list of parsers,
 - and returns a parser that does *one* of
 - the parsers.
 -}

oneof :: (Parsing p,Symbol s) => [p s a] -> p s a
oneof = foldl1 (<|>) 

{- 
 - sym is a way of geting a symbol, and listifying it
 -}

sym  :: (Parsing p, Symbol s) => s -> p s [s]
sym s = (\x -> [x]) <$> symbol s

{-
 - srange is a way of checking for a set of possible symbols.
 -}



-}





