module DataXML (
	XMLDoc(..),
	XML(..),
	XmlAttr(..),
	XMLElement(..),
	{- getDepthXML, -}
	) where

import Char (isSpace)
import Monad

data XMLDoc = XMLDoc [XmlAttr] XML deriving Show

data XML = XMLTag String [XmlAttr] [XMLElement]
--	deriving Show
data XMLElement = XMLElement XML
	        | XMLStr     String
--	deriving Show

type XmlAttr = (String,String)

instance Show XML where
    showsPrec p   xml  = showString (rmBlank (showXML  0 xml))

instance Show XMLElement where
    showsPrec p   xml  = showString (rmBlank (showXMLE  0 xml))
    showList      xmls = showString (rmBlank (showXMLEs 0 xmls))


rmBlank = unlines . filter (not . all isSpace) . lines

showXMLEs n xs = concat [ replicate n ' ' ++ showXMLE n t ++ " \n" | t <- xs ]

showXML n (XMLTag name attr [])  =
	(renderTag name attr n "/>")
showXML n (XMLTag name attr xmls)  =
	(renderTag name attr n "> ") ++
	showXMLEs (n+2) xmls ++ " \n" ++
	(replicate n ' ' ++ "</" ++ name ++ ">\n")

showXMLE n (XMLElement e) = showXML n e
showXMLE n (XMLStr str) = 
	case lines str of
	  [] -> ""
	  (hd:tl) -> hd ++ "\n" ++
		concat [ replicate n ' ' ++ t ++ "\n" | t <- tl ]

{-
getDepthXML :: Int -> XML -> XML
getDepthXML d (XMLTag str attr xmls)
	| d == 0    = XMLTag str [] []
	| otherwise = XMLTag str attr (map (getDepthXML (d-1)) xmls)
getDepthXML _ (XMLStr str) 
	| length str > 20 = XMLStr (take 20 str ++ "...")
	| otherwise	  = XMLStr str
-}

------------------------------------------------------------------------------

renderTag name [] n end = "<" ++ name ++ end ++ "\n" ++ replicate (n+2) ' '
renderTag name [(tag,val)] n end
	= "<" ++ name ++ " " ++ tag ++ "=" ++ show val ++ end 
		++ "\n" ++ replicate (n+2) ' '
renderTag name pairs@(hd:tl) n end
	= "<" ++ name ++ " " ++ showPair hd ++ "\n" ++
		foldr1 (\ x y -> x ++ "\n" ++ y)
			 [ replicate (n + 1 + length name + 1) ' ' 
				++ showPair p | p <- tl ] ++ end ++ 
			"\n" ++	replicate (n+2) ' '
  where
	showPair :: XmlAttr -> String
	showPair (tag,val) = tag ++ replicate (tagsz - length tag) ' ' ++ 
			" = " ++ show val 

	tagsz = maximum (map (length.fst) pairs)


------------------------------------------------------------------------------

