module LL1Parsing where

import ClassSymbol
import ClassParsing

-- ****************************************************************************
instance Parsing Parser where

--  succeed   :: Symbol s => a -> p s a
    succeed v  = End (\ input -> (v,  input)) noTree

--  symbol    :: Symbol s => s -> p s s
    symbol s  =  Choices [(s, End (\ (s:ss) -> (s, ss)) noTree)]

--  (<|>)     :: Symbol s => p s a      ->  p s a -> p s a
    (End p ct)      <|>   (End p' ct')    = error  "Ambiguous grammar (two empty/recovery alternatives?)" -- End p (ct <|> ct')
    (Prefix p ct)   <|>   ct'             =  push p ct <|> ct'
    ct              <|>   (Prefix q  ct') =  ct <|> push q ct'
    (End p ct)      <|>   ct'             =  End p (ct <|> ct')
    ct'             <|>   (End p ct)      =  End p (ct <|> ct')
    (Choices   cs  )<|>   (Choices   cs') =  Choices (foldr insert_in_choices cs' cs)
--  (<*>)     :: Symbol s => p s (b->a) ->  p s b -> p s a
    ptree <*> qtree
	 = case ptree 
	   of Choices cs    -> Choices [(s, p <*>qtree) | (s, p) <- cs]
	      End  p ct     -> (ct <*> qtree) <|> Prefix p qtree
	      Prefix p ct   -> push p ct <*> qtree
--  (<=>)     :: Symbol s => String     ->  p s a -> p s a
--  (<==>)    :: Symbol s => String     -> (p s a -> p s a) -> p s a
-------Calling
p `parse` input = let (steps, (v, errors)) = tryp p input id in (v, foldr ($) "" errors)
------- Type Definitions
type ChoosePars s a = Input s -> Prefix s -> (a, [ Error])
type RealParser s a = ([s] -> (a, [s]))
--type RealParser s a = (MonadLexer m) => m a
type Input s = [s]
type Prefix s = [s] -> [s]
type Error = (String -> String)
-- Choice Trees--==============================================================


--s -> (a,s)

data Parser     s a    = Choices  [(s, Parser s a)]    
                       | End     (RealParser s a)  (Parser s a)
                       | forall b . Prefix  (RealParser s (b -> a)) (Parser s b)


class Monad m => MonadLexer m where
    mtoken :: m a

-- Alternation--==============================================================

insert_in_choices (s,ct) []  = [(s,ct)]
insert_in_choices x@(s,ct) (y@(s',ct'):rest) 
    | s == s'   = (s',  ct' <|> ct):rest
    | otherwise = y:insert_in_choices  x rest

push :: RealParser s (a -> b) -> Parser s a -> Parser s b
push q (Choices cs)  = Choices [(s, Prefix q t) | (s, t) <- cs]
push q (End p ct)    = End    (q `seqqq` p)  (Prefix q ct) 
push q (Prefix p ct) = Prefix q (push p ct)

-- Sequencing--==============================================================

p `seqqq` q  = \ input ->  let (pv, rest)  =  p  input
                               (qv, rrest) =  q  rest 
                           in  (pv qv, rrest)

--Selectiona and Recovery =====================================================================
tryp :: (Eq s, Show s) =>  Parser s a -> Input s -> Prefix s -> ([Step],(a, [Error]))
tryp t@(Choices cs) 
   = \ input prefix -> 
         case input
         of []      -> fails (foldr1 best [insert_ s' input (tryp t' input (prefix.(s':)))
						| (s',t') <- cs])
            (s:ss)  -> case lookup s cs 
                       of Just t'   -> oks (tryp t' ss (prefix.(s:))) 
                          Nothing   -> fails (foldr best  
					(deleted s ss (tryp t (tail input) prefix))
					[insert_ s' input (tryp t' input (prefix.(s':)) )
						| (s',t') <- cs])
tryp t@( End p   ct) 
   = \ input prefix -> case input 
                         of []     -> ([], (fst ( p (prefix [])), []))
                            (s:ss) -> fails (deleted s ss (tryp t (tail input) prefix))
                                                  `best`
                                      tryp ct input prefix 
tryp ( Prefix p ct) 
   = \ input prefix -> let (pv,rest) = p (prefix [])
                           (steps, (qv,erq)) = tryp ct input (rest++)
                       in  (steps, ((pv qv), erq))

{-
lookupSymbol           :: Symbol a => a -> [(a,b)] -> Maybe b
lookupSymbol k []       = Nothing
lookupSymbol k ((x,y):xys)
      | k `cmpSymbol` x      = Just y
      | otherwise = lookup k xys
-}

-- Elementary parsers--==============================================================
noTree = Choices  []
-------Utility Functions------------------------

insert_ what  wher   = adderror "inserted: " (show what) ( wher)
deleted what wher   = adderror "deleted : " (show what) ( wher)

--adderror :: (Symbol a,Show b) => String -> a -> [b] -> ([Step], (d,[Error])) -> ([Step], (d,[Error]))
adderror msg what whre (steps,~(v,errors))
 = (steps,(v, ((msg++).((show what)++)
              .("\nbefore " ++).((case whre of (n:_) ->show n; _ -> "endoffile")++).("\n"++)):errors))

best :: ([Step],a) -> ([Step], a) -> ([Step],a) -- mind the laziness of this formulation!!
x@(xt,xv) `best` y@(yt,yv) 
  = xt `select` yt
    where (Failstep:aa)`select` (Failstep:bb)= fails (aa `select` bb)
          _            `select` []           = ([],yv)
          []           `select` _            = ([],xv)
          l            `select` (Failstep:_) = (l ,xv)
          (Failstep:_) `select` l            = (l ,yv)
          (a:xt)       `select` (b:yt)       = oks (xt `select` yt)
          

data Step = Okstep |Failstep deriving Show 
fails ~(x, y) = (Failstep:x, y)
oks   ~(x, y) = (Okstep  :x, y)                                      

