----------------------------------------------------------------------------
-- Gandalf.hs

module Gandalf
  ( gandalf
  )
 where

{- This module implements a link to the gandalf first order logic
   theorem prover.
-}

import Form
import Theory
import Clausify

import System
  ( system
  )

----------------------------------------------------------------------------
-- gandalf

gandalf :: [Theory] -> Form -> IO ()
gandalf ths f =
  do writeFile file (unlines (run generate))
     --system "gandalf system.galf"
     return ()
 where
  file = "system.galf"
  
  generate =
    do lsTheory   <- sequence [ generateTheory th | th <- ths ]
       lsQuestion <- generateQuestion f
       return $
            [ "% Generated by a Haskell program"
            , "set(industrial)."
            , "set(prolog_style_variables)."
            , ""
            , "list(usable)."
            , ""
            ]
         ++ concat lsTheory
         ++ [ "end_of_list."
            , ""
            , "list(sos)."
            , ""
            ]
         ++ lsQuestion
         ++ [ "end_of_list."
            ]
  
  generateTheory (Theory name axioms) =
    do css <- sequence [ clausify axiom | axiom <- axioms ]
       return $
            [ "% THEORY: " ++ name
            ]
         ++ map showClause (concat css)
         ++ [ ""
            ]
  
  generateQuestion f =
    do cs <- clausify (nt f)
       return $
            [ "% QUESTION"
            ]
         ++ map showClause cs
         ++ [ ""
            ]
     
----------------------------------------------------------------------------
-- the end.

