----------------------------------------------------------------------------
-- Theory.hs

module Theory where

{- This module implements theories.
-}

import Form

----------------------------------------------------------------------------
-- theories

data Theory
  = Theory String [Form]

-- basic equality

basicEquality :: Theory
basicEquality =
  Theory "basic equality"
    [ forall $ \x -> x <==> x
    ]

-- time

t0 :: Term
t0 = Fun "t0" []

s :: Term -> Term
s t = Fun "s" [t]

-- bool

inv :: Term -> Term
inv x = Fun "inv" [x]

true, false :: Term
true  = Fun "true" []
false = Fun "false" []

isBool :: Term -> Form
isBool x = Pred "bool" [x]

bool :: Theory
bool =
  Theory "bool"
    [ nt (true <==> false)
    --, isBool true
    , isBool false
    , forall $ \x -> isBool x ==> ((x <==> false) <|> (x <==> true))

    , inv true  <==> false
    , inv false <==> true
    ]

----------------------------------------------------------------------------
-- the end.

