----------------------------------------------------------------------------
-- Toggle.hs

module Toggle where

import Form
import Theory
import Gandalf

----------------------------------------------------------------------------
-- toggles

theories =
  [ toggleSystem1
  , toggleSystem2
  ]

-- 1

toggle1 t = Pred "toggle1" [t]

toggleSystem1 =
  Theory "toggle with one delay"
    [ nt (toggle1 t0)
    , forall $ \t -> toggle1 (s t) <=> nt (toggle1 t)
    ]

-- 2

toggle2 t = Pred "toggle2" [t]

toggleSystem2 =
  Theory "toggle with two delays"
    [ nt (toggle2 t0)
    , toggle2 (s t0)
    , forall $ \t -> toggle2 (s (s t)) <=> toggle2 t
    ]

-- question

prop t =
  toggle1 t <=> toggle2 t

-- main

main =
  gandalf theories (forall $ \t -> prop t) 

----------------------------------------------------------------------------
-- the end.
