-------------------------------------------------------------------------------
-- Concurrent Haskell Debugger
--   Concurrent Module
--     by Thomas Boettcher <thomas.boettcher@gmx.de>
-------------------------------------------------------------------------------

module CHD.DebugInterface
  (
    DebugMsg(..),
    sendDebugMsg		-- :: DebugMsg -> IO(C.MVar ())
  )
  where


-------------------------------------------------------------------------------
-- IMPORTS
-------------------------------------------------------------------------------

import qualified Control.Concurrent as C
import System.IO.Unsafe

import CHD.DebugMsgChan
import CHD.DebugMain
import CHD.Environment


-------------------------------------------------------------------------------
-- FUNCTIONS
-------------------------------------------------------------------------------

sendDebugMsg :: DebugMsg -> IO(C.MVar ())
sendDebugMsg message = do
  debugstop <- msgCHD message
  putStr forkDebug
  return debugstop


forkDebug :: String
forkDebug = unsafePerformIO( do
  chdMessage "start (first Message to debugMsgChan)"
  chdMessage "forking Message-Handler"
  myId <- C.myThreadId
  chdMessage "Message-Handler: go!"
  C.forkIO (startChd myId)
  return []
  )


