-------------------------------------------------------------------------------
-- Concurrent Haskell Debugger 
--   Enviroment Module
--     by Thomas Boettcher <thomas.boettcher@gmx.de>
-------------------------------------------------------------------------------

-- here are some features implemented.

-- first: chdMessage: these are messages from the CHD-Bib to stderror 
--                      to debug the debugger ;-)

-- second: checking for constants set by enviroment-variable CHD.OPTION


module CHD.Environment
  (
    activateBreakThread,
--    autoContinueTimeoutOption,
    autoContinueOption,
    removeArrowDelayOption,
    removeElementDelayOption,
    chdMessage
  )
  where


-------------------------------------------------------------------------------
-- IMPORTS
-------------------------------------------------------------------------------

import System.Environment
import System.IO
import System.IO.Unsafe
import Data.Maybe


-------------------------------------------------------------------------------
-- TYPES
-------------------------------------------------------------------------------


-------------------------------------------------------------------------------
-- FUNCTIONS
-------------------------------------------------------------------------------


activateBreakThread :: Int
activateBreakThread =
  getCHD_Option "activateBreakThread" "ABT" "1"


autoContinueTimeoutOption :: Int
autoContinueTimeoutOption = 
  getCHD_Option "autoContinueTimeout" "ACT" "100"

autoContinueOption :: Int
autoContinueOption = 
  getCHD_Option "autoContinueOption" "ACO" "0"

removeArrowDelayOption :: Int
removeArrowDelayOption = 
  getCHD_Option "removeArrowDelay" "RAD" "750"


removeElementDelayOption :: Int
removeElementDelayOption = 
  getCHD_Option "removeElementDelay" "RED" "5000"


chdMessage :: String -> IO ()
chdMessage message = 
  hPutStrLn stderr ("* CHD: " ++ message)


getCHD_Option :: String -> String -> String -> Int
getCHD_Option name short defaultValue = unsafePerformIO (do
  getvar <- myGetVarDefault "CHD_OPTION" (short ++ defaultValue)
  let value = (foldr
	        (\(test, value2) value1 -> 
		  if (test == short) 
		    then value2 
		    else value1)
		defaultValue
		(map (splitAt (length short)) (words getvar)))
      numberValue = [ x | x <- value, elem x "0123456789" ]
  chdMessage ("CHD_OPTION (" ++ short ++ ") " ++ name ++ " = " ++ value ++ 
	      " (" ++ numberValue ++ ")")
  return (read numberValue)
  )


-------------------------------------------------------------------------------
-- Main get Enviroment Functions
-------------------------------------------------------------------------------

   	    

myGetVarDefault :: String -> String -> IO String
myGetVarDefault var def = do
  res <- myGetVar var
  return (fromMaybe def res)


myGetVar :: String -> IO (Maybe String)
myGetVar var = do
  catch (getEnv var >>= 
	  (\x -> return (Just x))) -- can only be NoSuchThing
        (\_ -> return Nothing)
