-------------------------------------------------------------------------------
-- Concurrent Haskell Debugger 
--   GuiWindow Module
--     by Thomas Boettcher <thomas.boettcher@gmx.de>
-------------------------------------------------------------------------------

-- this module defines all types needed to open configuration-windows.

-- here the communication between CHD und config-windows can be expanded.


module CHD.GuiWindow
  where


-------------------------------------------------------------------------------
-- IMPORTS
-------------------------------------------------------------------------------

import Tcl

import CHD.BaseTypes

-------------------------------------------------------------------------------
-- TYPES
-------------------------------------------------------------------------------

-- defining the windows.

data GuiWindow = VisualizationConfigWindow
		 | ActionBreakConfigWindow
		 | SourceCodeViewWindow
		 | ProgressViewWindow
  deriving (Eq,Ord)
instance Show GuiWindow where
  showsPrec _ VisualizationConfigWindow = 
    showString "Config Visualize Elements"
  showsPrec _ ActionBreakConfigWindow =
    showString "Config Break Action"
  showsPrec _ SourceCodeViewWindow = 
    showString "View SourceCode"
  showsPrec _ ProgressViewWindow = 
    showString "View Progress"


-- defining the config-keys

data GuiListboxKey = EnableListbox
		   | DisableListbox
		   | SelectListbox
  deriving (Eq,Show)
	      
data GuiEditKey = DisplayEdit
  deriving (Eq,Show)

data GuiCanvasKey = ProgressCanvas
  deriving (Eq,Show)

-- these are the messages which are transportet from CHD trough GUI 
--	 to the window-operators

data GuiWinMsg = InsertListbox GuiListboxKey [String]
	       | RemoveListbox GuiListboxKey [String]
	       | Select GuiListboxKey String String
	       | MarkEdit GuiEditKey Int String String
	       | UnmarkEdit GuiEditKey Int
  deriving (Eq,Show)


type OperateGuiWin = GuiWinMsg -> GUI ()

instance Show OperateGuiWin where
  showsPrec _ _ = showString "<OperateGuiWin>"


parseKey :: String -> GuiListboxKey
parseKey configKey =
  case configKey of
       "EnableListbox"	-> EnableListbox
       "DisableListbox" -> DisableListbox
       "SelectListbox"	-> SelectListbox 
       string		-> error ("parseKey " ++ string)


parseGuiWindow :: String -> GuiWindow
parseGuiWindow guiWindow =
  case guiWindow of
       "VisualizationConfigWindow" -> VisualizationConfigWindow
       "ActionBreakConfigWindow"   -> ActionBreakConfigWindow 
       "SourceCodeViewWindow"	   -> SourceCodeViewWindow
       string			   -> error ("parseGuiWindow " ++ string)


parseGuiWinMsg :: [String] -> GuiWinMsg
parseGuiWinMsg (guiWinMsg:key:strings) =
  case guiWinMsg of
       "Add" -> InsertListbox (parseKey key) strings
       "Del" -> RemoveListbox (parseKey key) strings
       strings -> error ("parseGuiWinMsg " ++ show strings)
