import GHC
import HscTypes

doWalk :: [String] -> String -> Ghc ()
doWalk cmdFlags file = do
    flg <- getSessionDynFlags
    (flg, _, _) <- parseDynamicFlags flg (map noLoc cmdFlags)
    setSessionDynFlags flg { ghcLink = NoLink, ghcMode = OneShot }
    resFlags <- getSessionDynFlags
    liftIO $ print $ outputFile resFlags
    liftIO $ print $ outputHi resFlags
    addTarget Target { targetId = TargetFile file Nothing, targetAllowObjCode = False, targetContents = Nothing }
    load LoadAllTargets
    return ()

main = do
    let lib = Just "/usr/lib/ghc-6.12.1"
    runGhc lib $ doWalk ["-c", "-o", "output/A.o", "-ohi", "output/A.hi"] "src/A.hs"
