// 
//   Copyright (C) 2005, 2006, 2007 Free Software Foundation, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "LoadVariablesThread.h"
#include "tu_file.h"
#include "log.h"

#include <string>

namespace gnash {

void
LoadVariablesThread::completeLoad()
{
	//log_msg("completeLoad called");

	// Hong Yu -- debug
	log_msg( "HYU_DEBUG: %s: INSIDE \n", __PRETTY_FUNCTION__ );

	using std::string;

	// TODO: how to set _bytesTotal ?

	// this is going to override any previous setting,
	// better do this inside a subclass (in a separate thread)
	_bytesLoaded = 0;

	string toparse;

	size_t CHUNK_SIZE = 1024;
	char *buf = new char[CHUNK_SIZE];
	unsigned int parsedLines = 0;
	while ( size_t read = _stream->read_bytes(buf, CHUNK_SIZE) )
	{
		//log_msg("Read %u bytes", read);

		// Hong Yu -- debug
		log_msg( "HYU_DEBUG: %s: read %u bytes \n", __PRETTY_FUNCTION__, read );

		bool newlineFound = false;

		// found newline, discard anything before that
		for (size_t t=0; t<read; ++t)
		{
			if ( buf[t] == '\n' )
			{
				newlineFound = true;
				buf[t] = '\0';
			}
		}

		// TODO: use read_string ?
		string chunk(buf, read);
		toparse += chunk;

		// Hong Yu -- tempted fix
		_rawVal += chunk;

		//log_msg("toparse: %s", toparse.c_str());

		// Hong Yu -- debug
		log_msg( "HYU_DEBUG: %s: toparse [%s] \n", __PRETTY_FUNCTION__, toparse.c_str() );

		// parse remainder
		size_t lastamp = toparse.rfind('&');
		if ( lastamp != string::npos )
		{
			string parseable = toparse.substr(0, lastamp);
			//log_msg("parseable: %s", parseable.c_str());

			// Hong Yu -- debug
			log_msg( "HYU_DEBUG: %s: parseable [%s] \n", __PRETTY_FUNCTION__, parseable.c_str() );

			parse(parseable);
			toparse = toparse.substr(lastamp+1);
			//log_msg("toparse nextline: %s", toparse.c_str());

			// Hong Yu -- debug
			log_msg( "HYU_DEBUG: %s: toparse nextline [%s] \n", __PRETTY_FUNCTION__, toparse.c_str() );

			++parsedLines;
		}

		_bytesLoaded += read;
		//dispatchDataEvent();

		// found newline, discard anything before that
		if ( newlineFound )
		{
			if ( parsedLines ) break;
			else toparse.clear();
		}

		// eof, get out !
		if ( _stream->get_eof() ) break;
	}

	if ( ! toparse.empty() )
	{
		// Hong Yu -- tempted fix -- debug
		log_msg( "HYU_DEBUG: %s: toparse before parsing [%s];\t\t _rawVal [%s] \n", __PRETTY_FUNCTION__, toparse.c_str(), _rawVal.c_str() );

		parse(toparse);
	}

	_stream->go_to_end();
	_bytesLoaded = _stream->get_position();
	_bytesTotal = _bytesLoaded;

	//dispatchLoadEvent();
	delete[] buf;
	setCompleted();
}

} // namespace gnash 
