// Action script...

// [Initial MovieClip Action of sprite 20]
#initclip 1
class TwangoVideoPlayer extends MovieClip
{
    var mediaName, channelName, siteUrl, canShare, firstFrame_mc, lastFrame_mc, videoUrl, imageUrl, videoWidth, videoHeight, videoDuration, videoLengthString, shareUrl, nc, video, video_v, ns, sound_mc, sound_s, attachMovie, temp_nc, temp_ns, temp_video_v, temp_sound_mc, temp_sound_s, videoStart, rewind_mc, playPause_mc, sizeToggle_mc, mute_mc, progressBar_mc, normal_txt, timeCode_txt, embed_txt, loadBar_mc, lastFrameBG_mc, share_btn, replay_btn, embedCorner_mc, getURL, volume_mc, volumeBall_mc, _xmouse, startDrag, _x, stopDrag, rotateCW_mc, rotateCCW_mc, _alpha;
    function TwangoVideoPlayer()
    {
        super();
    } // End of the function
    function setMaxWidth(w)
    {
        maxWidth = w;
    } // End of the function
    function setMaxHeight(h)
    {
        maxHeight = h;
    } // End of the function
    function setVideoPlayerWidth(w)
    {
        videoPlayerWidth = w;
    } // End of the function
    function setIsWebcamMode(v)
    {
        isWebcamMode = v;
    } // End of the function
    function setIsEmbedded(f)
    {
        isEmbedded = f;
    } // End of the function
    function setVideoInited(f)
    {
        videoInited = f;
    } // End of the function
    function setBufferCalculated(f)
    {
        bufferCalculated = f;
    } // End of the function
    function setIsAutoPlay(a)
    {
        isAutoPlay = a;
    } // End of the function
    function setVolumeBarWidth(w)
    {
        volumeBarWidth = w;
    } // End of the function
    function setEmbedded()
    {
        isEmbedded = true;
    } // End of the function
    function checkOnSiteStatus()
    {
        if (_root.t == undefined || _root.t == "" || _root.t == null)
        {
            return;
        } // end if
        viewerTwangoId = _root.t;
        isMember = true;
        if (_root.fs == "1")
        {
            isFull = true;
        } // end if
        if (_root.mute == "1")
        {
            isMuted = true;
        } // end if
        if (_root.vol != undefined && !isNaN(_root.vol))
        {
            videoVolume = Number(_root.vol);
        } // end if
        if (videoVolume > 100 || videoVolume < 0)
        {
            videoVolume = 100;
        } // end if
    } // End of the function
    function getVideoData(mediaName, channelName)
    {
        this.checkOnSiteStatus();
        this.mediaName = mediaName;
        this.channelName = channelName;
        isOwner = mediaName.toLowerCase().indexOf(viewerTwangoId.toLowerCase() + ".") == 0;
        siteUrl = _root.site;
        if (siteUrl == undefined)
        {
            siteUrl = "http://www.twango.com/";
        }
        else if (siteUrl.toLowerCase() == "localhost")
        {
            siteUrl = "http://localhost/";
        }
        else if (siteUrl.toLowerCase() == "staging")
        {
            siteUrl = "http://staging.twango.com/";
        } // end else if
        canShare = _root.s != "false";
        var _loc4 = this.createLoadUrl();
        var _loc3 = new LoadVars();
        _loc3.load(_loc4);
        var thisVideo = this;
        _loc3.onData = function (src)
        {
            thisVideo.onVideoDataLoad(src);
        };
    } // End of the function
    function getSiteUrl()
    {
        return (siteUrl);
    } // End of the function
    function getFirstFrame()
    {
        return (firstFrame_mc);
    } // End of the function
    function getLastFrame()
    {
        return (lastFrame_mc);
    } // End of the function
    function createLoadUrl()
    {
        return (this.getSiteUrl() + "flash/video.aspx?versioning=" + TwangoUtility.getGuid() + "&media=" + mediaName + (channelName == undefined ? ("") : ("&channelname=" + channelName)));
    } // End of the function
    function onVideoDataLoad(src)
    {
        var _loc2 = src.split(",");
        videoUrl = _loc2[0];
        imageUrl = _loc2[1];
        videoWidth = Number(_loc2[2]);
        videoHeight = Number(_loc2[3]);
        videoDuration = Number(_loc2[4]);
        rotateDegrees = Number(_loc2[6]);
        if (isNaN(rotateDegrees))
        {
            rotateDegrees = 0;
        }
        else if (rotateDegrees == 270)
        {
            rotateDegrees = -90;
        } // end else if
        if (videoWidth == 0 || videoHeight == 0)
        {
            videoWidth = 320;
            videoHeight = 240;
        } // end if
        videoLength = videoDuration > 600 ? (600) : (videoDuration);
        videoLengthString = this.getTimeCode(videoLength);
        channelName = _loc2[5];
        this.initVideoPlayer();
    } // End of the function
    function initVideoPlayer()
    {
        shareUrl = siteUrl + "share.aspx?channelname=" + channelName + "&media=" + mediaName;
        nc = new NetConnection();
        nc.connect(null);
        this.initNetStream();
        video_v = video;
        video_v.attachVideo(ns);
        sound_mc = _root.createEmptyMovieClip("sound_mc", 10000);
        sound_mc.attachAudio(ns);
        sound_s = new Sound(sound_mc);
        sound_s.setVolume(videoVolume);
        if (isMuted)
        {
            isMuted = false;
            this.soundToggle();
        } // end if
        if (!isEmbedded)
        {
            this.beginVideo();
            if (isFull)
            {
                this.fullScreen();
            }
            else
            {
                this.originalSize();
            } // end else if
        }
        else
        {
            var thisVideo = this;
            firstFrame_mc = this.attachMovie("firstFrame_mc", "firstFrame_mc", 1001);
            if (imageUrl.indexOf("processing.jpg") > -1)
            {
                temp_nc = new NetConnection();
                temp_nc.connect(null);
                temp_ns = new NetStream(temp_nc);
                temp_ns.setBufferTime(1.000000E-001);
                temp_video_v = firstFrame_mc.video_v;
                temp_video_v.attachVideo(temp_ns);
                temp_sound_mc = firstFrame_mc.createEmptyMovieClip("sound_mc", 10000);
                temp_sound_mc.attachAudio(temp_ns);
                temp_sound_s = new Sound(temp_sound_mc);
                temp_sound_s.setVolume(0);
                temp_ns.play(videoUrl);
                temp_ns.onStatus = function (info)
                {
                    if (info.code == "NetStream.Play.Start")
                    {
                    }
                    else if (info.code == "NetStream.Play.Stop")
                    {
                    }
                    else if (info.code == "NetStream.Buffer.Full")
                    {
                    }
                    else if (info.code == "NetStream.Buffer.Empty")
                    {
                        temp_video_v.attachVideo(null);
                        temp_ns.pause();
                        temp_ns.play("nonexist.flv");
                    } // end else if
                };
                temp_ns.seek(0);
                temp_ns.pause(true);
            }
            else
            {
                var _loc3 = firstFrame_mc.image_mc.createEmptyMovieClip("firstShotImage_mc", 0);
                firstFrame_mc.loadListener = new Object();
                firstFrame_mc.loadListener.onLoadComplete = function (target_mc, httpStatus)
                {
                };
                firstFrame_mc.loadListener.onLoadInit = function (target_mc)
                {
                    target_mc._parent.originalWidth = target_mc._width;
                    target_mc._parent.originalHeight = target_mc._height;
                    target_mc._parent._width = target_mc._width;
                    target_mc._parent._height = target_mc._height;
                    thisVideo.fullScreen();
                };
                firstFrame_mc.loadListener.onLoadError = function (target_mc, errorCode, httpStatus)
                {
                    trace (">> loadListener.onLoadError()");
                    trace (">> ==========================");
                    trace (">> errorCode: " + errorCode);
                    trace (">> httpStatus: " + httpStatus);
                };
                firstFrame_mc.slideLoader = new MovieClipLoader();
                firstFrame_mc.slideLoader.addListener(firstFrame_mc.loadListener);
                firstFrame_mc.slideLoader.loadClip(imageUrl, _loc3);
            } // end else if
            firstFrame_mc.onRelease = firstFrame_mc.firstPlay_mc.onRelease = function ()
            {
                thisVideo.playPauseToggle();
            };
        } // end else if
        this.initControls();
    } // End of the function
    function beginVideo()
    {
        if (isEmbedded)
        {
            firstFrame_mc._visible = false;
            if (isFull)
            {
                this.fullScreen();
            }
            else
            {
                this.originalSize();
            } // end if
        } // end else if
        videoInited = true;
        ns.play(videoUrl);
        videoStart = new Date().getTime();
        var thisVideo = this;
        function onEnterFrame()
        {
            thisVideo.calculateBuffer();
        } // End of the function
    } // End of the function
    function initNetStream()
    {
        ns = new NetStream(nc);
        ns.setBufferTime(50);
        var thisVideo = this;
        ns.onMetaData = function (info)
        {
            if (isNaN(thisVideo.videoLength) || info.duration != thisVideo.videoLength)
            {
                thisVideo.videoLength = info.duration;
                thisVideo.videoLengthString = thisVideo.getTimeCode(thisVideo.videoLength);
            } // end if
        };
        ns.onStatus = function (info)
        {
            if (info.code == "NetStream.Play.Start")
            {
            }
            else if (info.code == "NetStream.Play.Stop")
            {
                thisVideo.endVideo();
            }
            else if (info.code == "NetStream.Buffer.Full")
            {
            }
            else if (info.code == "NetStream.Buffer.Empty")
            {
            } // end else if
        };
    } // End of the function
    function initControls()
    {
        rewind_mc = rewind_mc;
        playPause_mc = playPause_mc;
        sizeToggle_mc = sizeToggle_mc;
        mute_mc = mute_mc;
        progressBar_mc = progressBar_mc;
        if (isFull)
        {
            sizeToggle_mc.gotoAndStop("showFull");
        }
        else
        {
            sizeToggle_mc.gotoAndStop("showOriginal");
        } // end else if
        if (isWebcamMode || !isEmbedded)
        {
            timeCode_txt = normal_txt;
        }
        else
        {
            timeCode_txt = embed_txt;
        } // end else if
        loadBar_mc = loadBar_mc;
        lastFrame_mc = this.attachMovie("lastFrame_mc", "lastFrame_mc", 15000);
        lastFrameBG_mc = lastFrame_mc.lastFrameBG_mc;
        share_btn = lastFrame_mc.share_btn;
        replay_btn = lastFrame_mc.replay_btn;
        playPause_mc.gotoAndStop("showPlay");
        loadBar_mc._x = 0;
        progressBar_mc._x = 0;
        loadBar_mc._width = 0;
        progressBar_mc._width = 0;
        lastFrameBG_mc._visible = false;
        share_btn._visible = false;
        replay_btn._visible = false;
        var thisVideo = this;
        rewind_mc.onRelease = function ()
        {
            thisVideo.rewindVideo();
        };
        playPause_mc.onRelease = function ()
        {
            thisVideo.playPauseToggle();
        };
        if (videoWidth >= maxWidth || videoHeight >= maxHeight)
        {
            this.fullScreen();
            sizeToggle_mc._alpha = 50;
        }
        else
        {
            sizeToggle_mc.onRelease = function ()
            {
                if (thisVideo.isFull)
                {
                    thisVideo.originalSize();
                }
                else
                {
                    thisVideo.fullScreen();
                } // end else if
                thisVideo.saveState();
            };
        } // end else if
        mute_mc.onRelease = function ()
        {
            thisVideo.soundToggle();
            thisVideo.saveState();
        };
        if (isMuted)
        {
            mute_mc.gotoAndStop("showMute");
        }
        else
        {
            mute_mc.gotoAndStop("showOn");
        } // end else if
        loadBar_mc.onEnterFrame = function ()
        {
            thisVideo.loadProgress();
        };
        loadBar_mc.onPress = function ()
        {
            thisVideo.ns.pause(true);
            thisVideo.progressBar_mc.onEnterFrame = function ()
            {
                thisVideo.scrubVideo();
            };
        };
        loadBar_mc.onRelease = loadBar_mc.onReleaseOutside = function ()
        {
            thisVideo.endScrubVideo();
        };
        var _loc2 = embedCorner_mc;
        if (isEmbedded)
        {
            var mediaUrl = siteUrl + "media.aspx?media=" + mediaName + (channelName == undefined ? ("") : ("&channelname=" + channelName));
            _loc2._alpha = 100;
            var _loc4 = _loc2.embedShare_btn;
            _loc4.onRelease = function ()
            {
                thisVideo.share();
            };
            var _loc5 = _loc2.twango_mc;
            _loc5.onRelease = function ()
            {
            };
        }
        else
        {
            _loc2._visible = false;
        } // end else if
        volume_mc = volume_mc;
        volumeBall_mc = volume_mc.volumeBall_mc;
        var _loc3 = volume_mc.volumeBG_mc;
        _loc3.useHandCursor = false;
        _loc3.onRelease = function ()
        {
            thisVideo.volumeBall_mc._x = _xmouse;
            thisVideo.setVolume(_xmouse);
            thisVideo.saveState();
        };
        volumeBall_mc._x = videoVolume / 100 * volumeBarWidth;
        volumeBall_mc._alpha = 100;
        volumeBall_mc.onPress = function ()
        {
            this.startDrag(true, 0, 2.700000E+000, thisVideo.volumeBarWidth, 2.700000E+000);
            function onEnterFrame()
            {
                thisVideo.setVolume(Math.round(_x / thisVideo.volumeBarWidth * 100));
            } // End of the function
        };
        volumeBall_mc.onRelease = volumeBall_mc.onReleaseOutside = function ()
        {
            delete this.onEnterFrame;
            this.stopDrag();
            thisVideo.setVolume(Math.round(_x / thisVideo.volumeBarWidth * 100));
            thisVideo.saveState();
        };
        if (isOwner)
        {
            rotateCW_mc = rotateCW_mc;
            rotateCCW_mc = rotateCCW_mc;
            rotateCW_mc._alpha = 100;
            rotateCCW_mc._alpha = 100;
            rotateCW_mc.onRelease = function ()
            {
                thisVideo.rotateVideo(true);
            };
            rotateCCW_mc.onRelease = function ()
            {
                thisVideo.rotateVideo(false);
            };
        } // end if
        this.afterInitControls();
    } // End of the function
    function afterInitControls()
    {
    } // End of the function
    function resetBufferCalculation()
    {
        videoInited = false;
        bufferCalculated = false;
        bufferCount = 0;
        videoStart = new Date().getTime();
    } // End of the function
    function calculateBuffer()
    {
        if (videoLength <= 0)
        {
            return;
        } // end if
        if (bufferCalculated)
        {
            delete this.onEnterFrame;
            return;
        } // end if
        ns.seek(0);
        ns.pause(true);
        var _loc3 = (new Date().getTime() - videoStart) / 1000;
        var _loc4 = ns.bytesTotal * 1.100000E+000 / ns.bytesLoaded * _loc3;
        var _loc2 = _loc4 - videoLength;
        if (ns.bytesLoaded == ns.bytesTotal)
        {
            bufferCount = 10;
        } // end if
        if (bufferCount >= 10 && (ns.bytesLoaded == ns.bytesTotal || _loc3 > _loc2))
        {
            if (ns.bytesLoaded == ns.bytesTotal)
            {
                ns.setBufferTime(0);
            } // end if
            bufferCalculated = true;
            this.playFromStart();
            delete this.onEnterFrame;
            return;
        } // end if
        ns.setBufferTime(_loc2);
        ++bufferCount;
    } // End of the function
    function loadProgress()
    {
        loadBar_mc._xscale = ns.bytesLoaded / ns.bytesTotal * 100;
        if (loadBar_mc._xscale >= 100)
        {
            delete loadBar_mc.onEnterFrame;
        } // end if
    } // End of the function
    function videoUpdate()
    {
        progressBar_mc._width = ns.time / videoLength * videoPlayerWidth;
        this.updateTimeCode();
        if (progressBar_mc._width > videoPlayerWidth)
        {
            progressBar_mc._width = videoPlayerWidth;
        } // end if
        if (progressBar_mc._width < videoPlayerWidth * 9.700000E-001)
        {
            return;
        } // end if
        if (progressBar_mc._width != lastWidth)
        {
            lastWidth = progressBar_mc._width;
            lastWidthCount = 0;
        }
        else
        {
            ++lastWidthCount;
            if (lastWidthCount > 10)
            {
                lastWidth = 0;
                lastWidthCount = 0;
                this.endVideo();
            } // end if
        } // end else if
    } // End of the function
    function scrubVideo()
    {
        ns.seek(Math.floor(videoLength * (_root._xmouse / maxWidth)));
        progressBar_mc._width = _root._xmouse;
        this.updateTimeCode();
    } // End of the function
    function endScrubVideo()
    {
        if (isPlaying)
        {
            ns.pause(false);
        } // end if
        var thisVideo = this;
        progressBar_mc.onEnterFrame = function ()
        {
            thisVideo.videoUpdate();
        };
    } // End of the function
    function updateTimeCode()
    {
        timeCode_txt.text = this.getTimeCode(ns.time) + " / " + videoLengthString;
    } // End of the function
    function rewindVideo()
    {
        ns.seek(0);
        timeCode_txt.text = this.getTimeCode(0) + " / " + videoLengthString;
        progressBar_mc._width = 0;
    } // End of the function
    function playPauseToggle()
    {
        if (!videoInited)
        {
            this.beginVideo();
            this.afterPlayPauseToggle();
            return;
        } // end if
        if (!bufferCalculated)
        {
            bufferCalculated = true;
            this.playFromStart();
            this.afterPlayPauseToggle();
            return;
        } // end if
        if (lastFrameBG_mc._visible)
        {
            this.playFromStart();
            this.afterPlayPauseToggle();
            return;
        } // end if
        if (isPlaying)
        {
            playPause_mc.gotoAndStop("showPlay");
            ns.pause(true);
            delete progressBar_mc.onEnterFrame;
        }
        else
        {
            playPause_mc.gotoAndStop("showPause");
            ns.pause(false);
            var thisVideo = this;
            progressBar_mc.onEnterFrame = function ()
            {
                thisVideo.videoUpdate();
            };
        } // end else if
        isPlaying = !isPlaying;
        this.afterPlayPauseToggle();
    } // End of the function
    function afterPlayPauseToggle()
    {
    } // End of the function
    function pauseVideo()
    {
        isPlaying = false;
        ns.pause(true);
        delete progressBar_mc.onEnterFrame;
    } // End of the function
    function fullScreen()
    {
        isFull = true;
        sizeToggle_mc.gotoAndStop("showFull");
        var _loc2 = video_v;
        var _loc3 = videoWidth;
        var _loc4 = videoHeight;
        if (isEmbedded && firstFrame_mc._visible)
        {
            _loc2 = firstFrame_mc.image_mc;
            _loc3 = _loc2._width;
            _loc4 = _loc2._height;
        } // end if
        if (rotateDegrees == 90 || rotateDegrees == -90)
        {
            _loc3 = videoHeight;
            _loc4 = videoWidth;
        } // end if
        _loc2._rotation = rotateDegrees;
        var _loc5;
        var _loc6;
        if (_loc3 / _loc4 > maxWidth / maxHeight)
        {
            _loc5 = maxWidth;
            _loc6 = Math.round(_loc4 * maxWidth / _loc3);
            _loc2._width = maxWidth;
            _loc2._height = Math.round(_loc4 * maxWidth / _loc3);
            _loc2._x = 0;
            _loc2._y = Math.round((maxHeight - _loc2._height) / 2);
        }
        else
        {
            _loc6 = maxHeight;
            _loc5 = Math.round(_loc3 * maxHeight / _loc4);
            _loc2._height = maxHeight;
            _loc2._width = Math.round(_loc3 * maxHeight / _loc4);
            _loc2._y = 0;
            _loc2._x = Math.round((maxWidth - _loc5) / 2);
        } // end else if
        if (isWebcamMode)
        {
            _loc2._x = 5;
            _loc2._y = 5;
        } // end if
        if (rotateDegrees == 90)
        {
            _loc2._x = _loc2._x + _loc5;
        }
        else if (rotateDegrees == -90)
        {
            _loc2._y = _loc2._y + _loc6;
        }
        else if (rotateDegrees == 180 || rotateDegrees == -180)
        {
            _loc2._x = _loc2._x + _loc5;
            _loc2._y = _loc2._y + _loc6;
        } // end else if
        _loc2._width = _loc5;
        _loc2._height = _loc6;
        this.afterFullScreen(_loc2);
    } // End of the function
    function afterFullScreen(obj_mc)
    {
    } // End of the function
    function originalSize()
    {
        isFull = false;
        sizeToggle_mc.gotoAndStop("showOriginal");
        var _loc2 = video_v;
        var _loc3 = videoWidth;
        var _loc4 = videoHeight;
        _loc2._rotation = 0;
        if (isEmbedded && firstFrame_mc._visible)
        {
            _loc2 = firstFrame_mc.image_mc;
            _loc3 = _loc2.originalWidth;
            _loc4 = _loc2.originalHeight;
            _loc2._rotation = 0;
        } // end if
        if (_loc2._width > maxWidth || _loc2._height > maxHeight)
        {
            this.fullScreen();
            return;
        } // end if
        _loc2._width = _loc3;
        _loc2._height = _loc4;
        if (rotateDegrees == 90 || rotateDegrees == -90)
        {
            _loc2._x = Math.round((maxWidth - _loc4) / 2);
            _loc2._y = Math.round((maxHeight - _loc3) / 2);
            if (rotateDegrees == 90)
            {
                _loc2._x = _loc2._x + _loc4;
            }
            else
            {
                _loc2._y = _loc2._y + _loc3;
            } // end else if
        }
        else
        {
            _loc2._x = Math.round((maxWidth - _loc3) / 2);
            _loc2._y = Math.round((maxHeight - _loc4) / 2);
            if (rotateDegrees == 180 || rotateDegrees == -180)
            {
                _loc2._x = _loc2._x + _loc3;
                _loc2._y = _loc2._y + _loc4;
            } // end if
        } // end else if
        _loc2._rotation = rotateDegrees;
    } // End of the function
    function soundToggle()
    {
        if (isMuted)
        {
            sound_s.setVolume(videoVolume);
            mute_mc.gotoAndStop("showOn");
        }
        else
        {
            sound_s.setVolume(0);
            mute_mc.gotoAndStop("showMute");
        } // end else if
        isMuted = !isMuted;
    } // End of the function
    function setVolume(newVolume)
    {
        videoVolume = Math.round(newVolume);
        sound_s.setVolume(videoVolume);
        if (isMuted)
        {
            this.soundToggle();
        } // end if
    } // End of the function
    function saveState()
    {
        if (isMember)
        {
        } // end if
    } // End of the function
    function rotateVideo(rotateClockWise)
    {
        if (isOwner)
        {
            if (rotateClockWise)
            {
                rotateDegrees = rotateDegrees + 90;
            }
            else
            {
                rotateDegrees = rotateDegrees - 90;
            } // end else if
            if (rotateDegrees == 360)
            {
                rotateDegrees = 0;
            }
            else if (rotateDegrees == 270)
            {
                rotateDegrees = -90;
            }
            else if (rotateDegrees == -180)
            {
                rotateDegrees = 180;
            } // end else if
            if (isFull)
            {
                this.fullScreen();
            }
            else
            {
                this.originalSize();
            } // end else if
        } // end if
    } // End of the function
    function getTimeCode(theTime)
    {
        var _loc4 = Math.round(theTime);
        var _loc3 = Math.floor(_loc4 / 60);
        var _loc2 = _loc4 % 60;
        var _loc1 = "";
        if (_loc3 < 10)
        {
            _loc1 = _loc1 + "0";
        } // end if
        if (_loc3 >= 1)
        {
            _loc1 = _loc1 + _loc3.toString();
        }
        else
        {
            _loc1 = _loc1 + "0";
        } // end else if
        _loc1 = _loc1 + ":";
        if (_loc2 < 10)
        {
            _loc1 = _loc1 + ("0" + _loc2.toString());
        }
        else
        {
            _loc1 = _loc1 + _loc2.toString();
        } // end else if
        return (_loc1);
    } // End of the function
    function playFromStart()
    {
        this.hideLastFrame();
        if (!isAutoPlay)
        {
            isAutoPlay = true;
            return;
        } // end if
        ns.seek(0);
        ns.pause(false);
        isPlaying = true;
        playPause_mc.gotoAndStop("showPause");
        var thisVideo = this;
        progressBar_mc.onEnterFrame = function ()
        {
            thisVideo.videoUpdate();
        };
    } // End of the function
    function endVideo()
    {
        delete progressBar_mc.onEnterFrame;
        playPause_mc.gotoAndStop("showPlay");
        isPlaying = false;
        ns.pause(true);
        this.showLastFrame();
    } // End of the function
    null[] = !isEmbedded ? (function ()
    {
    }) : ("share");
    function showLastFrame()
    {
        progressBar_mc._width = 0;
        lastFrameBG_mc._alpha = 0;
        lastFrameBG_mc._visible = true;
        timeCode_txt.text = this.getTimeCode(0) + " / " + videoLengthString;
        this.afterShowLastFrame();
    } // End of the function
    function afterShowLastFrame()
    {
        var thisVideo = this;
        replay_btn.onRelease = function ()
        {
            thisVideo.playFromStart();
        };
        share_btn.onRelease = function ()
        {
            thisVideo.share();
        };
        lastFrameBG_mc.onEnterFrame = function ()
        {
            _alpha = _alpha + 10;
            if (_alpha > 50)
            {
                _alpha = 50;
                thisVideo.ns.seek(0);
                thisVideo.replay_btn._visible = true;
                if (thisVideo.canShare)
                {
                    thisVideo.share_btn._visible = true;
                }
                else
                {
                    thisVideo.replay_btn._x = (Stage.width - thisVideo.replay_btn._width) / 2;
                } // end else if
                delete this.onEnterFrame;
            } // end if
        };
    } // End of the function
    function hideLastFrame()
    {
        lastFrameBG_mc._visible = false;
        share_btn._visible = false;
        replay_btn._visible = false;
    } // End of the function
    var isEmbedded = false;
    var maxWidth = 512;
    var maxHeight = 384;
    var videoPlayerWidth = 512;
    var videoLength = -1;
    var rotateDegrees = 90;
    var videoInited = false;
    var isPlaying = false;
    var isFull = false;
    var volumeBarWidth = 100;
    var lastWidth = 0;
    var lastWidthCount = 0;
    var bufferCount = 0;
    var bufferCalculated = false;
    var isMember = false;
    var viewerTwangoId = "";
    var isOwner = false;
    var isMuted = false;
    var videoVolume = 100;
    var isWebcamMode = false;
    var isAutoPlay = true;
} // End of Class
#endinitclip
