// Action script...

// [Action in Frame 1]
function init()
{
    thumb_mc._visible = false;
    error_mc._visible = false;
    filename = "/buzz_videos";
    title_mc.content_txt.text = _root.t == undefined ? ("Videos being watched right now...") : (unescape(_root.t));
    home_mc = this;
    startDepth = 1000;
    colMax = 5;
    rowCurrent = 0;
    tCurrent = 0;
    tHideTime = 75;
    rowTimeShown = 8000;
    rowMaxDisplayed = 36;
    userInteracting = false;
    trackMarginTop = 10;
    trackMarginBottom = 5;
    trackMarginSide = 10;
    trackSideLeft = trackMarginSide;
    trackSideRight = Stage.width - trackMarginSide;
    trackSideTop = trackMarginTop;
    trackSideBottom = Stage.height - trackMarginBottom;
    trackXRange = Stage.width - trackMarginSide * 2;
    trackSpacing = trackXRange / colMax;
    info = new Array();
    pos = new Object();
    pos.startP = 8.300000E-001;
    pos.startX = new Array();
    pos.startY = vanish_mc._y + (showline_mc._y - vanish_mc._y) * pos.startP;
    pos.showP = 9.500000E-001;
    pos.showX = new Array();
    pos.showY = showline_mc._y;
    pos.showMargin = 6;
    pos.showCtr = (Stage.width - thumb_mc._width - pos.showMargin * 2) / (colMax - 1);
    pos.showTime = 12;
    pos.finalP = 1.300000E+000;
    pos.finalX = new Array();
    pos.finalY = vanish_mc._y + (showline_mc._y - vanish_mc._y) * pos.finalP;
    pos.finalTime = 35;
    pos.rollOverTime = 4;
    pos.startToShowX = new Object();
    pos.startToShowY = new Object();
    pos.startToShowP = new Object();
    fader_mc._alpha = 0;
    fader_mc.swapDepths(4999);
    progress_mc.swapDepths(5001);
    title_mc.swapDepths(5002);
    showline_mc._visible = false;
    home_mc.createEmptyMovieClip("lines_mc", 1);
    lines_mc._visible = false;
    lines_mc.lineStyle(0, 16711935, 100);
    for (var _loc3 = 0; _loc3 < colMax; ++_loc3)
    {
        pos.showX[_loc3] = pos.showMargin + thumb_mc._width / 2 + pos.showCtr * _loc3;
        pos.startX[_loc3] = pos.showX[_loc3] + (vanish_mc._x - pos.showX[_loc3]) * (1 - pos.startP);
        pos.finalX[_loc3] = pos.showX[_loc3] + (vanish_mc._x - pos.showX[_loc3]) * (1 - pos.finalP);
        lines_mc.moveTo(vanish_mc._x, vanish_mc._y);
        lines_mc.lineTo(pos.showX[_loc3], pos.showY);
        pos.startToShowX["col" + _loc3] = new Array();
        pos.startToShowY["col" + _loc3] = new Array();
        pos.startToShowP["col" + _loc3] = new Array();
        for (var _loc4 = 0; _loc4 <= pos.showTime; ++_loc4)
        {
            pos.startToShowX["col" + _loc3][_loc4] = easeIn(_loc4, pos.startX[_loc3], pos.showX[_loc3] - pos.startX[_loc3], pos.showTime);
            pos.startToShowY["col" + _loc3][_loc4] = easeIn(_loc4, pos.startY, pos.showY - pos.startY, pos.showTime);
            pos.startToShowP["col" + _loc3][_loc4] = easeIn(_loc4, pos.startP, pos.showP - pos.startP, pos.showTime) * 100;
        } // end of for
    } // end of for
    intImgLoading();
    loadXML(filename);
} // End of the function
function hideProgress()
{
    progress_mc.onEnterFrame = function ()
    {
        this._alpha = this._alpha - 25;
        this._xscale = this._xscale + 10;
        this._yscale = this._yscale + 10;
        this._y = this._y + 7;
        if (this._alpha <= 0)
        {
            progress_mc.stop();
            progrees_mc._visible = false;
            this.onEnterFrame = function ()
            {
            };
        } // end if
    };
} // End of the function
function easeIn(t, b, c, d)
{
    t = t / d;
    return (c * (t / d) * t * t * t + b);
} // End of the function
function easeOut(t, b, c, d)
{
    t = t / d - 1;
    return (-c * ((t / d - 1) * t * t * t - 1) + b);
} // End of the function
function onXMLLoaded()
{
    hideProgress();
    createNewRow(rowCurrent);
    currentInterval = setInterval(onShowNextRow, rowTimeShown);
} // End of the function
function onXMLError(error_status)
{
    error_mc._visible = true;
    progress_mc._visible = false;
    progress_mc.stop();
} // End of the function
function onNewRowCreated(row)
{
    home_mc.createEmptyMovieClip("loadChecker_mc", home_mc.getNextHighestDepth());
    home_mc.loadChecker_mc.onEnterFrame = function ()
    {
        var _loc3 = true;
        for (var _loc2 = 0; _loc2 < colMax; ++_loc2)
        {
            _loc3 = home_mc["thumb" + row + _loc2 + "_mc"].imgLoaded;
        } // end of for
        if (_loc3)
        {
            showThumbs(row);
            this.onEnterFrame = function ()
            {
            };
        } // end if
    };
} // End of the function
function onShowThumbs(row)
{
    rowCurrent = row;
} // End of the function
function onHideThumbs(row)
{
} // End of the function
function onShowNextRow()
{
    if (rowCurrent >= rowMaxDisplayed)
    {
        clearInterval(currentInterval);
    } // end if
    if (!userInteracting)
    {
        createNewRow(rowCurrent + 1);
    } // end if
} // End of the function
function onThumbRollOver()
{
    home_mc.createEmptyMovieClip("mousetracker_mc", home_mc.getNextHighestDepth());
    home_mc.mousetracker_mc.current_mc = this;
    home_mc.mousetracker_mc.oldX = _xmouse;
    home_mc.mousetracker_mc.oldY = _ymouse;
    home_mc.mousetracker_mc.onEnterFrame = function ()
    {
        if (Math.round(_xmouse) == Math.round(this.oldX) && Math.round(_ymouse) == Math.round(this.oldY))
        {
            ++this.count;
            if (this.count > tHideTime)
            {
                this.current_mc.onRollOut();
                this.onEnterFrame = function ()
                {
                };
            } // end if
        }
        else
        {
            this.count = 0;
            this.oldX = _xmouse;
            this.oldY = _ymouse;
        } // end else if
    };
    userInteracting = true;
    this.swapDepths(5000);
    this.active = true;
    updateFadeThumbs(this.row, this.col);
    this.count = 0;
    this.onEnterFrame = function ()
    {
        if (this._y < pos.showY + this.showIncY / 2 * pos.rollOverTime)
        {
            this._x = this._x + this.showIncX / 2;
            this._y = this._y + this.showIncY / 2;
            this._xscale = this._xscale + this.showIncP / 2;
            this._yscale = this._yscale + this.showIncP / 2;
            this.hitArea_mc._yscale = this.hitArea_mc._yscale + 4;
        } // end if
        ++this.count;
        if (this.count >= pos.rollOverTime)
        {
            this.title_mc._visible = true;
            this.onEnterFrame = function ()
            {
            };
        } // end if
    };
} // End of the function
function onThumbRollOut()
{
    userInteracting = false;
    this.active = false;
    this.title_mc._visible = false;
    updateFadeThumbs(this.row, this.col);
    this.onEnterFrame = function ()
    {
        this._x = this._x - this.showIncX / 2;
        this._y = this._y - this.showIncY / 2;
        this._xscale = this._xscale - this.showIncP / 2;
        this._yscale = this._yscale - this.showIncP / 2;
        this.hitArea_mc._yscale = this.hitArea_mc._yscale - 4;
        if (this._y <= pos.showY)
        {
            this._x = pos.showX[this.col];
            this._y = pos.showY;
            this._xscale = pos.showP * 100;
            this._yscale = pos.showP * 100;
            this.onEnterFrame = function ()
            {
            };
        } // end if
    };
} // End of the function
function onThumbRelease()
{
    getURL(info[this.infoID].url, "");
} // End of the function
function loadXML(filename)
{
    var data_xml = new XML();
    data_xml.ignoreWhite = true;
    data_xml.onLoad = function (success)
    {
        if (success)
        {
            var _loc8 = data_xml.firstChild.firstChild.childNodes.length;
            var _loc5 = new Array();
            var _loc4 = new Array();
            for (var _loc7 = 0; _loc7 < _loc8; ++_loc7)
            {
                _loc5.push(_loc7);
            } // end of for
            for (var _loc7 = 0; _loc7 < _loc8; ++_loc7)
            {
                var _loc6 = Math.floor(Math.random() * _loc5.length);
                _loc4.push(_loc5[_loc6]);
                _loc5.splice(_loc6, 1);
            } // end of for
            var _loc3 = 0;
            for (var _loc2 = data_xml.firstChild.firstChild.firstChild; _loc2 != null; _loc2 = _loc2.nextSibling)
            {
                info[_loc4[_loc3]] = new Array();
                for (var _loc1 = _loc2.firstChild; _loc1 != null; _loc1 = _loc1.nextSibling)
                {
                    info[_loc4[_loc3]][_loc1.nodeName] = _loc1.firstChild.nodeValue;
                } // end of for
                ++_loc3;
            } // end of for
            if (_loc3 == 0)
            {
                onXMLError();
            }
            else
            {
                onXMLLoaded();
            } // end else if
        }
        else
        {
            onXMLError(data_xml.status);
        } // end else if
    };
    data_xml.load(filename);
} // End of the function
function createNewRow(row)
{
    for (var _loc2 = 0; _loc2 < colMax; ++_loc2)
    {
        duplicateMovieClip("thumb_mc", "thumb" + row + _loc2 + "_mc", startDepth--);
        var _loc1 = home_mc["thumb" + row + _loc2 + "_mc"];
        _loc1.title_mc._visible = false;
        loadThumbImg(row, _loc2, info[tCurrent].thumbnail_url);
        _loc1.infoID = tCurrent;
        _loc1.row = row;
        _loc1.col = _loc2;
        _loc1.showIncX = (pos.showX[_loc2] - pos.startX[_loc2]) / pos.showTime;
        _loc1.showIncY = (pos.showY - pos.startY) / pos.showTime;
        _loc1.showIncP = (pos.showP - pos.startP) * 100 / pos.showTime;
        _loc1.finalIncX = (pos.finalX[_loc2] - pos.showX[_loc2]) / pos.finalTime;
        _loc1.finalIncY = (pos.finalY - pos.showY) / pos.finalTime;
        _loc1.finalIncP = (pos.finalP - pos.showP) * 100 / pos.finalTime;
        _loc1._x = pos.startX[_loc2];
        _loc1._y = pos.startY;
        _loc1._xscale = pos.startP * 100;
        _loc1._yscale = pos.startP * 100;
        _loc1.onRelease = onThumbRelease;
        _loc1.onRollOver = onThumbRollOver;
        _loc1.onRollOut = onThumbRollOut;
        _loc1.enabled = false;
        _loc1.title_mc.content_txt.text = info[tCurrent].title;
        _loc1.overlay_mc.length_txt.text = info[tCurrent].run_time;
        _loc1.overlay_mc.viewers_txt.text = info[tCurrent].viewers;
        ++tCurrent;
        if (tCurrent >= info.length)
        {
            tCurrent = 0;
        } // end if
    } // end of for
    onNewRowCreated(row);
} // End of the function
function showThumbs(row)
{
    home_mc.createEmptyMovieClip("ctrlShow" + row + "_mc", this.getNextHighestDepth());
    if (row > 0)
    {
        hideThumbs(row - 1);
    } // end if
    home_mc["ctrlShow" + row + "_mc"].timer = 0;
    home_mc["ctrlShow" + row + "_mc"].count = 0;
    home_mc["ctrlShow" + row + "_mc"].onEnterFrame = function ()
    {
        if (Math.floor(this.timer / 3) == this.timer / 3)
        {
            var _loc2 = home_mc["thumb" + row + this.count + "_mc"];
            _loc2.count = 0;
            _loc2.onEnterFrame = function ()
            {
                this._x = pos.startToShowX["col" + this.col][this.count];
                this._y = pos.startToShowY["col" + this.col][this.count];
                this._xscale = pos.startToShowP["col" + this.col][this.count];
                this._yscale = this._xscale;
                ++this.count;
                if (this.count > pos.showTime)
                {
                    this.enabled = true;
                    this.onEnterFrame = function ()
                    {
                    };
                } // end if
            };
            _loc2.gotoAndPlay("show");
            if (this.count++ >= colMax)
            {
                onShowThumbs(row);
                this.onEnterFrame = function ()
                {
                };
            } // end if
        } // end if
        ++this.timer;
    };
} // End of the function
function hideThumbs(row)
{
    for (var _loc3 = 0; _loc3 < colMax; ++_loc3)
    {
        var _loc2 = home_mc["thumb" + row + _loc3 + "_mc"];
        _loc2.enabled = false;
        _loc2.count = 0;
        _loc2.onEnterFrame = function ()
        {
            this._x = this._x + this.finalIncX;
            this._y = this._y + this.finalIncY;
            this._xscale = this._xscale + this.finalIncP;
            this._yscale = this._yscale + this.finalIncP;
            ++this.count;
            if (this.count >= pos.finalTime)
            {
                if (this.col == 0)
                {
                    killAllOldThumbs();
                } // end if
                this._visible = false;
                this.removeMovieClip();
                this.onEnterFrame = function ()
                {
                };
            } // end if
        };
        _loc2.gotoAndPlay("hide");
    } // end of for
} // End of the function
function killAllOldThumbs()
{
    var _loc3 = rowCurrent - 1;
    for (var _loc2 = 0; _loc2 < colMax; ++_loc2)
    {
        var _loc1 = home_mc["thumb" + _loc3 + _loc2 + "_mc"];
        if (_loc1._x != undefined)
        {
            _loc1.enabled = false;
            _loc1._visible = false;
            _loc1.removeMovieClip();
        } // end if
    } // end of for
} // End of the function
function updateFadeThumbs(row, col)
{
    var _loc3 = false;
    for (var _loc2 = 0; _loc2 < colMax; ++_loc2)
    {
        if (home_mc["thumb" + row + _loc2 + "_mc"].active)
        {
            _loc3 = true;
            break;
        } // end if
    } // end of for
    if (_loc3)
    {
        fader_mc.onEnterFrame = function ()
        {
            if (this._alpha <= 30)
            {
                this._alpha = this._alpha + 5;
            }
            else
            {
                this._alpha = 30;
                this.onEnterFrame = function ()
                {
                };
            } // end else if
        };
    }
    else
    {
        fader_mc.count = 0;
        fader_mc.onEnterFrame = function ()
        {
            if (this._alpha > 5)
            {
                if (this.count > 5)
                {
                    this._alpha = this._alpha - 10;
                } // end if
            }
            else
            {
                this._alpha = 0;
                this.onEnterFrame = function ()
                {
                };
            } // end else if
            ++this.count;
        };
    } // end else if
} // End of the function
function intImgLoading()
{
    var _loc1 = new Object();
    _loc1.onLoadStart = function (target_mc)
    {
    };
    _loc1.onLoadComplete = function (target_mc)
    {
    };
    _loc1.onLoadError = function (target_mc, errorCode, httpStatus)
    {
    };
    _loc1.onLoadInit = function (target_mc)
    {
        target_mc._xscale = (home_mc.thumb_mc.main_mc._width - 4) / target_mc._width * 100;
        target_mc._yscale = target_mc._xscale;
        target_mc._x = target_mc._width / -2;
        target_mc._y = -target_mc._height;
        target_mc._parent._parent.imgLoaded = true;
    };
    image_mcl = new MovieClipLoader();
    image_mcl.addListener(_loc1);
} // End of the function
function loadThumbImg(row, col, filename)
{
    var current_mc = home_mc["thumb" + row + col + "_mc"];
    current_mc.main_mc.createEmptyMovieClip("imgHolder_mc", current_mc.main_mc.getNextHighestDepth());
    current_mc.reflection_mc.createEmptyMovieClip("imgHolder_mc", current_mc.main_mc.getNextHighestDepth());
    current_mc.main_mc.createEmptyMovieClip("mask_mc", current_mc.main_mc.getNextHighestDepth());
    current_mc.reflection_mc.createEmptyMovieClip("mask_mc", current_mc.main_mc.getNextHighestDepth());
    var w = home_mc.thumb_mc.main_mc._width - 4;
    var h = home_mc.thumb_mc.main_mc._height - 4;
    with (current_mc.main_mc.mask_mc)
    {
        beginFill(255, 30);
        lineStyle(0, 16711935, 50);
        moveTo(-w / 2, -h - 2);
        lineTo(w / 2, -h - 2);
        lineTo(w / 2, -2);
        lineTo(-w / 2, -2);
        lineTo(-w / 2, -h - 4);
        endFill();
    } // End of with
    with (current_mc.reflection_mc.mask_mc)
    {
        beginFill(255, 30);
        lineStyle(0, 16711935, 50);
        moveTo(-w / 2, -h - 2);
        lineTo(w / 2, -h - 2);
        lineTo(w / 2, -2);
        lineTo(-w / 2, -2);
        lineTo(-w / 2, -h - 4);
        endFill();
    } // End of with
    current_mc.main_mc.setMask(current_mc.main_mc.mask_mc);
    current_mc.reflection_mc.setMask(current_mc.reflection_mc.mask_mc);
    image_mcl.loadClip(filename, current_mc.main_mc.imgHolder_mc);
    image_mcl.loadClip(filename, current_mc.reflection_mc.imgHolder_mc);
} // End of the function
init();
stop ();
