/* Copyright (C) 2008 The goocanvasmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "examplewindow.h"
#include <cairomm/cairomm.h>
#include <iostream>

ExampleWindow::ExampleWindow():
    m_pressed (false)
{
  set_title("goocanvasmm - Custom Item Example");

  m_canvas.set_size_request(640, 480);
  m_canvas.set_bounds(0, 0, 1000, 1000);


  Glib::RefPtr<ExampleItem> item = ExampleItem::create(100, 100, 400, 400);
  item->property_line_width().set_value(10.0);
  item->property_stroke_color().set_value("yellow");
  item->property_fill_color().set_value("red");

  Glib::RefPtr<Goocanvas::Item> root = m_canvas.get_root_item();
  root->add_child(item);

  Gtk::ScrolledWindow* sw = Gtk::manage(new Gtk::ScrolledWindow());
  sw->add(m_canvas);
  add(*sw);

  m_canvas.signal_button_press_event().connect (
       sigc::mem_fun (*this, &ExampleWindow::on_canvas_mouse_pressed));
  m_canvas.signal_button_release_event().connect (
       sigc::mem_fun (*this, &ExampleWindow::on_canvas_mouse_released));
  m_canvas.signal_motion_notify_event().connect (
       sigc::mem_fun (*this, &ExampleWindow::on_canvas_mouse_moved));

  show_all_children();
}

bool
ExampleWindow::on_canvas_mouse_pressed (GdkEventButton* event)
{
  m_canvas.convert_from_pixels (event->x, event->y);
  m_pressed = true;
  m_originX = event->x;
  m_originY = event->y;
  return false;
}

bool
ExampleWindow::on_canvas_mouse_released (GdkEventButton* event)
{
  m_pressed = false;
  if (m_createdItem) {
      m_createdItem.reset ();
  }
  return false;
}

bool
ExampleWindow::on_canvas_mouse_moved (GdkEventMotion* event)
{
  m_canvas.convert_from_pixels (event->x, event->y);
  if (m_pressed) {
      double x = event->x < m_originX ? event->x : m_originX;
      double y = event->y < m_originY ? event->y : m_originY;
      double w = abs (event->x - m_originX);
      double h = abs (event->y - m_originY);

      if (!m_createdItem && w > 2.0 && h > 2.0) {
          m_createdItem = ExampleItem::create (x, y, w, h);
          m_canvas.get_root_item()->add_child (m_createdItem);
      } else if (m_createdItem) {
          m_createdItem->set_size (x, y, w, h);
      }
  }
  return false;
}
