#!/usr/bin/env python
# coding: utf-8
# Modul Deutscher Schmerzfragebogen für MultiTest 0.1
# Ruthard Baudach
# 13.05.2007

import wx
import mtBase

_test_def = {
	'index': [ 'SBL' ], #'VAS'],# 'painDETECT', 'aWB', 'PDI', 'HADS', 'QLIP', 'SF-12' ],
	'SBL': {
		'caption': 'Schmerzbeschreibungsliste\n\nIch empfinde meine Schmerzen als...\n3 = trifft genau zu\t2 = trifft weitgehend zu\t1 = trifft ein wenig zu\t0 = trifft nicht zu',
		'index_layout': [
			'elend',
			'schauderhaft',
			'scheußlich',
			'furchtbar',
			'dumpf',
			'drückend',
			'klopfend',
			'pochend',
			'brennend',
			'heiß',
			'stechend',
			'ziehend'
			 ],
		'index_affektiv': [
			'elend',
			'schauderhaft',
			'scheußlich',
			'furchtbar',
			],
		'index_sensorisch': [
			'dumpf',
			'drückend',
			'klopfend',
			'pochend',
			'brennend',
			'heiß',
			'stechend',
			'ziehend'
			 ],
		'index_result_layout': [
			'score_affektiv',
			'score_sensorisch',
			'notice_affektiv',
			'notice_sensorisch',
			],
		'index_result': [
			'score_affektiv',
			'score_sensorisch',
			],
		'index_back': [
			'backnotice_affektiv',
			'score_affekiv',
			'backnotice_sensorisch',
			'score_sensorisch',
			],
		'size_questionaire': (6,2),
		'size_resultdisplay': (1,2),
		'elend': {
			'type': 'RadioBox',  # Art des Eingabefeldes
			'prompt': "elend",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'schauderhaft': {
			'type': 'RadioBox',
			'prompt': "schauderhaft",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'scheußlich': {
			'type': 'RadioBox',
			'prompt': "scheußlich",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'furchtbar': {
			'type': 'RadioBox',
			'prompt': "furchtbar",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'elend': {
			'type': 'RadioBox',  # Art des Eingabefeldes
			'prompt': "elend",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'dumpf': {
			'type': 'RadioBox',
			'prompt': "dumpf",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'drückend': {
			'type': 'RadioBox',
			'prompt': "drückend",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'klopfend': {
			'type': 'RadioBox',
			'prompt': "klopfend",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'pochend': {
			'type': 'RadioBox',  # Art des Eingabefeldes
			'prompt': "pochend",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'brennend': {
			'type': 'RadioBox',
			'prompt': "brennend",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'heiß': {
			'type': 'RadioBox',
			'prompt': "heiß",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'stechend': {
			'type': 'RadioBox',
			'prompt': "stechend",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'ziehend': {
			'type': 'RadioBox',
			'prompt': "ziehend",
			'choices': [ '3','2','1','0' ],
			'col': 0, # number of columns 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:3,1:2,2:1,3:0}, # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 3
			},
		'score_affektiv': {
			'type': 'TextInput',
			'prompt': 'Affektiver Score:',
			'size': (30,-1),
			},
		'score_sensorisch': {
			'type': 'TextInput',
			'prompt': 'Sensorischer Score:',
			'size': (30,-1),
			},
		'notice_affektiv': {
	  		'type': 'TextDisplay',
			'text': 'Ein Punktwert von 8\ngilt als Grenzwert für erhöhtes\naffektives Schmerzerleben.',
			'size': (200,-1),
			},
		'notice_sensorisch': {
	  		'type': 'TextDisplay',
			'text': 'Der Punktwert des sensorischen\nSchmerzerlebens kann als Maß\nfür die Schmerzstärke interpretiert werden.',
			'size': (200,-1),
			},
		'backnotice_affektiv': 'Schmerzbeschreibungsliste: affektiver Score: ',
	  	'backnotice_sensrisch': 'sensorischer Score: ',
		},
	'VAS': {
		'caption': 'Visuelle Analogscalen',
		'index_layout': [ 'aktuell','durchschnitt','max','ziel', 'line'],
		'index_score_intens': [ 'aktuell','durchschnitt','max' ],
		'size_questionaire': (4,1),
		'size_resultdisplay': (2,2),
		'aktuell': {
			'type': 'RadioBox',
			'prompt': "momentane Schmerzstärke",
			'choices': [ '0','1','2','3','4','5','6','7','8','9','10' ],
			'col': 0,
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,10:10},
			'default': 0
			},
		'durchschnitt': {
			'type': 'RadioBox',
			'prompt': "durchschnittliche Schmerzstärke der letzten 4 Wochen",
			'choices': [ '0','1','2','3','4','5','6','7','8','9','10' ],
			'col': 0,
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,10:10},
			'default': 0
			},
		'max': {
			'type': 'RadioBox',
			'prompt': "maximale Schmerzstärke der letzten 4 Wochen",
			'choices': [ '0','1','2','3','4','5','6','7','8','9','10' ],
			'col': 0,
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,10:10},
			'default': 0
			},
		'ziel': {
			'type': 'RadioBox',
			'prompt': "gut erträgliche Schmerzstärke",
			'choices': [ '0','1','2','3','4','5','6','7','8','9','10' ],
			'col': 0,
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,10:10},
			'default': 0
			},
		'line': {
			'type': 'Line',
			'size': (380,0)
			},
		'notice': 'Hier kann eine Bemerkung zu diesem Test hin,\n zum Beispiel eine Auswertung.\nDieser Text dient jetzt nur als Beispiel.'
		},
	'test1': {
		'caption': 'ProbeTest 1',
		'index_layout': [ 'item1','item2','item3',"item4" ],         # als extra um die Reihenfolge zu kennen
		'index_score': [ 'item1','item2','item3',"item4" ],
		'row': 3,	# number of rows of the test
		'col': 2,        # number of columns of the test
		'item1': {
			'type': 'RadioBox',  # Art des Eingabefeldes
			'prompt': "Prompt1",
			'choices': [ '0','1','2','3' ],
			'col': 0, # number of columns
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:0,1:1,2:2,3:3},  # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 0 # Voreinstellung
			},
		'item2': {
			'type': 'RadioBox',  # Art des Eingabefeldes
			'prompt': "Prompt1",
			'choices': [ '0','1','2','3' ],
			'col': 0, # number of columns
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:0,1:1,2:2,3:3},  # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 0 # Voreinstellung
			},
		'item3': {
			'type': 'RadioBox',  # Art des Eingabefeldes
			'prompt': "Prompt1",
			'choices': [ '0','1','2','3' ],
			'col': 0, # number of columns
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:0,1:1,2:2,3:3},  # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 0 # Voreinstellung
			},
		'item4': {
			'type': 'TextInput',
			'prompt': "Prompt2 - wie sieht das aus, wenn es ein bisschen länger ist?",
			'size': (30,-1),  #tuple mit Größe des TextCtrl Feldes
			'table': {0:0,1:1,2:2,3:3,4:4} # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			},
		'notice': 'Hier wird mal der Schweregrad ausgerechnet\nzur Zeit aber nur die Intesität..'
		}
	}

# ------------------------------------------------------------------------------------
# Klassendefinitionen
# ------------------------------------------------------------------------------------

class cTest(mtBase.cTest):
	"""
	Test.
	"""
	def __init__(self,parent):
		mtBase.cTest.__init__(self,parent=parent,template=_test_def,test='')

		test = {}

		for testname in _test_def['index']:
			if testname == 'Verlauf':
				test[testname] = cTestHistory(self,_test_def,'Verlauf')
			elif testname == 'SBL':
				test[testname] = cSBL(self,_test_def,testname)
			elif testname == 'VAS':
				test[testname] = cVAS(self,_test_def,testname)
			else:
				test[testname] = mtBase.TestPanel(self,_test_def,testname)
			self.AddPage(test[testname], testname)
		
			
 

class cSBL(mtBase.cTestDisplay):
	"""
	erstellt die Schmerzbeschreibungsliste
	"""
	def __init__(self,parent,template,test):
		mtBase.cTestDisplay.__init__(self,parent,template,test)
	
	#def _make_result_display(self):
		
		"""
		Returns sizer with result and comments.

		Has to be overridden if it does not suit the test.
		"""
		"""
		self.result = wx.GridSizer(2,2)
		for item in self.template[self.test]['index_result_layout']:
			
			try:
				width,hight = self.template[self.test][item]['size']
			except KeyError:
				pass

			controltype = self.template[self.test][item]['type']

			if controltype == 'TextInput':
				self.controls[item] = mtBase.cTextInput(self,self.test,item)
			elif controltype == 'Space':
				self.controls[item] = wx.Size(width,hight)
			elif controltype == 'Line':
				self.controls[item] = wx.StaticLine(self,-1,size=self.template[self.test][item]['size'])
			elif controltype == 'TextDisplay':
				self.controls[item] = mtBase.cTextDisplay(self,self.test,item)
			else:
				wx.MessageBox('Beim Layout der Resultatanzeige trat ein Fehler auf:\n\nAngefordertes Element nicht definiert','Fehler')
			self.result.Add(self.controls[item],0,wx.BOTTOM|wx.CENTRE,5)
		"""
		
	# ---------------------------------------------------------------
	def _refresh_score(self,evt):
		"""
		Diese Funktion muss bei abweichender Auswertung natürlich
		ebenfalls angepasst werden!
		"""
		
		score_affektiv = self._get_score(self.template[self.test]['index_affektiv'])
		self.controls['score_affektiv'].SetValue(str(score_affektiv))
		score_sensorisch = self._get_score(self.template[self.test]['index_sensorisch'])
		self.controls['score_sensorisch'].SetValue(str(score_sensorisch))

# -------------------------------------------------------------------------------

class VAS(mtBase.cTestDisplay):
	def __init__(self,parent,template,test):
		mtBase.cTestDisplay.__init__(self,parent=parent,template=_test_def,test='VAS')

	def getResult(self):
		"""
		gibt einen Sizer mit dem Ergebnis und einem Kommentar zurück.
		In abgeleiteten Klassen für Tests mit anderen Auswertungsvorschriften muß
		diese Funktion entsprechend angepasst werden.
		"""
		
		# Score ermitteln
		grade = self.getGrade()
		
		# do Layout
		resultlabel = wx.StaticText(self,-1,"Intensität: ")
		self.scoredisplay = wx.StaticText(self,-1,str(grade))
		notice = wx.StaticText(self,-1,self.template[self.test]['notice'])


		row = wx.BoxSizer(wx.HORIZONTAL)
		row.Add(resultlabel,0,wx.CENTRE,0)
		row.Add(self.scoredisplay,0,wx.CENTRE,0)
		sizer = wx.BoxSizer(wx.VERTICAL)
		sizer.Add(row,0,wx.BOTTOM|wx.CENTRE,5)
		sizer.Add(notice,0,wx.TOP|wx.CENTRE,5)

		return sizer
	
	# ---------------------------------------------------------------------

	def refreshScore(self,evt):
		"""
		Diese Funktion muss bei abweichender Auswertung natürlich
		ebenfalls angepasst werden!
		"""
		grade = self.getGrade() 
		self.scoredisplay.SetLabel(str(grade))

	def getGrade(self):
		grade = self.getScore(self.template[self.test]['index_score_intens']) / 3
		return grade
		
