#!/usr/bin/env python
# coding: utf-8
# MultiTest 0.2
# Medizinische Tests für den Computer
# Autor Ruthard Baudach
# 13.05,2007

"""
Main File running the application.

Multitest offers a range of modules with medical tests, an interface to import patient data via a csv-style file and to export results via a text file.

"""

import wx
import csv
import mtBase
import mtProcam
import mtSample

class cMultiTest(wx.App):

	"""
	The application.

	"""

	def OnInit(self):
		"""
		Calling the main Frame-
		"""
		self.MainFrame = cMultiTestFrame()
		self.MainFrame.Show()
		self.SetTopWindow(self.MainFrame)

		return True


class cMultiTestFrame(wx.Frame):
	"""
	Main Frame providing a top-level notebook and menu functionality.
	"""
	def __init__(self):
		wx.Frame.__init__(self,id=-1,parent=None,pos=(-1,-1),size=(800,600), title='Test',style=wx.DEFAULT_FRAME_STYLE,name='Hauptfenster')

		mtBase.currentPatient = self._get_patient_data()
		self._create_menu()
		self._do_layout()
		

	def _create_menu(self):
		""" Defines and binds the menu """
		# Menu-ID's
		idNewPatient = wx.NewId()
		idSave = wx.NewId()
		idExport = wx.NewId()
		idSaveAll =wx.NewId()
		idReturnToImported = wx.NewId()
		idExit = wx.NewId()
		idInfo = wx.NewId()
		idHelp = wx.NewId()
		
		# Menu
		FileMenu = wx.Menu()
		FileMenu.Append(idNewPatient,'&Neuer Patient')
		FileMenu.Append(idSave,'&Speichern')
		FileMenu.Append(idExport,'&Exportieren')
		FileMenu.Append(idReturnToImported,'&Zurücksetzen')
		FileMenu.Append(idExit,'&Beenden')
		HelpMenu = wx.Menu()
		HelpMenu.Append(idInfo,'&Info')
		HelpMenu.Append(idHelp,'&Hilfe')
				
		Menu = wx.MenuBar()
		Menu.Append(FileMenu,'&Datei')
		Menu.Append(HelpMenu,'&Hilfe')

		self.SetMenuBar(Menu)

		# Menu Events
		self.Bind(wx.EVT_MENU,self._on_new_patient,id=idNewPatient)
		self.Bind(wx.EVT_MENU,self._on_save,id=idSave)
		self.Bind(wx.EVT_MENU,self._on_export,id=idExport)
		self.Bind(wx.EVT_MENU,self._on_return_to_imported,id=idReturnToImported)
		self.Bind(wx.EVT_MENU,self._on_exit,id=idExit)
		self.Bind(wx.EVT_MENU,self._on_info,id=idInfo)
		self.Bind(wx.EVT_MENU,self._on_help,id=idHelp)
	
	def _do_layout(self):
		"""
		Creates and shows an top level notebook.

		The tests are derived from imported modules and added as pages to this notebook.
		"""
		self.pat = cPatientDisplay(self)
		
		self.nb = cNoteBook(self)

		border = wx.BoxSizer(wx.VERTICAL)
		border.Add(self.pat,0,wx.ALL,5)
		border.Add(self.nb,0,wx.ALL,0)
		self.SetSizerAndFit(border)

		self.GetBestSize
		self.CenterOnScreen()
		
	def _get_patient_data(self):
		"""
		Importing patient data from a csv file.
		
		Reads patient data from importfile and returns a dictionary.
		The importfile has to be a comma separated single line list with the data ordered according to the sequence defined in mtBase._base_def['index_import']
		The importfile itself is defined in mtBase._base_def['importfile']
		"""
		file = open(mtBase._base_def['importfile'],'r')
		reader = csv.DictReader(file,fieldnames=mtBase._base_def['index_import'])
		for PatData in reader:
			return PatData
		file.close()


	def _on_new_patient(self,evt):
		"""
		Gets patient anew from importfile and sets patient data in patientdisplay
		"""
		mtBase.currentPatient = self._get_patient_data()
		self.pat._set_patient(mtBase.currentPatient)
		self.nb.GetCurrentPage()._on_new_patient()
		
		
	def _on_save(self,evt):
		"""
		Saves the current test.
		"""
		self.nb.GetCurrentPage()._store_data()

	def _on_export(self,evt):
		"""
		Exports the result of the current test.
		"""
		self.nb.GetCurrentPage()._export()

	def _on_return_to_imported(self,evt):
		"""
		Sets the test to the imported values, if any.

		Works the same way as _on_new_patient, but with the already imported patient.
		"""
		self.nb.GetCurrentPage()._on_new_patient()

	def _on_exit(self,evt):
		"""
		Exits after saving - what??
		"""
		val = wx.GetSingleChoiceIndex('Aktuellen Test:','Programm beenden',['Speichern','Exportieren','Speichern und Exportieren','Beenden'])

		if val == 0:
			self._on_save(evt)
			self.Close()
		elif val == 1:
			self._on_export(evt)
			self.Close()
		elif val == 2:
			self._on_save(evt)
			self._on_export(evt)
			self.Close()
		elif val == 3:
			self.Close()
		

	def _on_info(self,evt):
		wx.MessageBox('Multitest 0.3\nMedizinische Testsammlung\nAutor Ruthard Baudach','Info')

	def _on_help(self,evt):
		wx.MessageBox('Hilfe!!!','Hilfe')  # ToDo write Help

# -----------------------------------------------------------------------------------
		
class cPatientDisplay(wx.BoxSizer):
	"""
	Displays patient data.

	This class creates a boxsizer showing patient number, name and birthdate in a row.
	_set_patient sets the data.
	"""

	def __init__(self,parent):
		wx.BoxSizer.__init__(self,wx.HORIZONTAL)
		
		self.lblNr = wx.StaticText(parent,-1,"PatNr:")
		self.lblName = wx.StaticText(parent,-1,"Name:")
		self.lblGeb = wx.StaticText(parent,-1,"geb.:")
		self.stNr = wx.TextCtrl(parent,-1,"",size=(50,-1))
		self.stName = wx.TextCtrl(parent,-1,"",size=(120,-1))
		self.stGeb = wx.TextCtrl(parent,-1,"",size=(50,-1))

		self.Add(self.lblNr,0,wx.ALL,5)
		self.Add(self.stNr,0,wx.ALL,5)
		self.Add(self.lblName,0,wx.ALL,5)
		self.Add(self.stName,0,wx.ALL,5)
		self.Add(self.lblGeb,0,wx.ALL,5)
		self.Add(self.stGeb,0,wx.ALL,5)

		self._set_patient(mtBase.currentPatient)


	def _set_patient(self,patient):
		PatName = patient['NN']+', '+patient ['VN']
		if patient['NZ'] != "":
			PatName = PatName+', '+ patient['NZ']
		self.stNr.SetValue(str(patient['Nr']))
		self.stName.SetValue(PatName)
		self.stGeb.SetValue(str(patient['Geb']))
		
class cNoteBook(wx.Notebook):
	"""
	Notebook with tests.
	"""
	# ToDo: automated configuration - how??
	def __init__(self,parent):
		wx.Notebook.__init__(self,parent,-1,style=wx.NB_TOP)
		#self.currentPatient = parent.currentPatient
		test = {}
		test['procam'] = mtProcam.cTest(self)
		self.AddPage(test['procam'], 'Procam Score')
		test['SampleTest'] = mtSample.cTest(self)
		self.AddPage(test['SampleTest'], 'Sample Test')


# ---------------------------------------------------------------------

app = cMultiTest()
app.MainLoop()
		
