#!/usr/bin/env python
# coding: utf-8
# ProcamModul für MultiTest 0.3
# Ruthard Baudach
# 13.05.2007

import wx
import mtBase




_test_def = {
	'index': [ 'procam' ],
	'procam': {
		'caption': 'ProcamScore',
		'index_layout': [ 'LDL', 'HDL', 'TG', 'BG', 'BP', 'AGE', 'Sex', 'leer', 'DM', 'Smoke', 'FH', 'Medis'  ],
		'index_score': [ 'LDL', 'HDL', 'TG', 'BG', 'BP', 'DM', 'AGE', 'Smoke', 'FH', 'Medis' ],
		'index_result_layout': ['score', 'notice'],
		'index_result': ['score'],
		'index_back': [('backnotice','risc')],
		'size_questionaire': (3,4),
		'size_resultdisplay': (2,1),
		'LDL': {
			'type': 'TextInput',
			'prompt': 'LDL',
			'size': (30,15),
			'table': { 100:0, 105:1, 110:2, 115:3, 120:4, 125:5, 130:6, 135:7, 140:8, 145:9, 150:10, 155:11, 160:12, 165:13, 170:14, 175:15, 180:16, 185:17, 190:18, 195:19, 196:20 }
			},
		'HDL': {
			'type': 'TextInput',
			'prompt': 'HDL',
			'size': (30,15),  
			'table': {35:11, 37:10, 39:9, 41:8, 43:7, 45:6, 47:5, 49:4, 51:3, 53:2, 55:1, 56:0}
			},
		'TG': {
			'type': 'TextInput',
			'prompt': 'TG',
			'size': (30,15),
			'table': {99:0, 149:2, 199:3, 200:4},
			},
		'BG': {
			'type': 'TextInput',
			'prompt': 'Bz',
			'size': (30,15),  
			'table': {119:0, 120:3} 
			},
		 'BP': {
			'type': 'TextInput',
			'prompt': 'Blutdruck',
			'size': (30,15),
			'table': {109:0, 119:1, 129:2, 139:3, 149:4, 159:5, 160:6} 
			},
		'DM': {
			'type': 'RadioBox',
			'prompt': 'DM',
			'choices': [ 'ja','nein' ],
			'col': 0, 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:4,1:0},  
			'default': 1 
			},
		'AGE': {
			'type': 'TextInput',
			'prompt': 'Alter',
			'size': (30,15),
			'table': {35:0, 36:1, 37:2, 38:3, 39:4, 40:5, 41:6, 42:7, 43:8, 44:9, 45:10, 46:11, 47:12, 48:13, 49:14, 50:15, 51:16, 52:17, 53:18, 54:19, 55:20, 56:21, 57:22, 58:23, 59:24, 60:25, 61:26, 62:27, 63:28, 64:29, 65:30}
			},
		'Smoke': {
			'type': 'RadioBox',
			'prompt': 'Raucher',
			'choices': [ 'ja','nein', 'Ex' ],
			'col': 0, 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:9,1:0,2:2},
			'default': 1 
			},
		'FH': {
			'type': 'RadioBox',
			'prompt': 'Familienanamnese',
			'choices': [ 'positiv','negativ' ],
			'col': 0, 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:5,1:0},
			'default': 1 
			},
		'Medis': {
			'type': 'RadioBox',
			'prompt': 'Blutdruckmedikamente',
			'choices': [ 'ja','nein' ],
			'col': 0, 
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:2,1:0},
			'default': 1 
			},
		'Sex': {
			'type': 'TextInput',
			'prompt': 'Geschlecht',
			'size': (30,15),
			'table': {} 
			},
		'leer':{
			'type': 'Space',
			'size': (20,20),
			},
		'score': {
			'type': 'TextInput',
			'prompt': 'Score:',
			'size': (30,15),
			},
		'risc': {
			'type': 'TextInput',
			'prompt': 'Risiko nach Procam:',
			'size': (30,15),
			},
		'notice': {
			'type': 'TextDisplay',
			'text': 'Das Risiko nach Procam gibt das 10-Jahresrisiko für einen Herzinfarkt an.\nDer PROCAM Score ist im Altersbereich von 35 bis 65 validiert.\n Jüngere Patienten haben ein tendenziell niedrigeres,\nältere ein tendenziell höheres Risiko als berechnet.',
			'size': (300,-1)
			},
		'backnotice': 'Das Risiko nach Procam beträgt: ',
 		'risc_high': {
			0:0, 1:0, 2:0, 3:0, 4:0, 5:0, 6:0, 7:0, 8:0, 9:0.1, 10:0.2, 11:0.2, 12:0.2, 13:0.3, 14:0.3, 15:0.4, 16:0.4, 17:0.4, 18:0.5, 19:0.6, 20:0.7, 21:0.8, 22:0.9, 23:1.0, 24:1.1, 25:1.2, 26:1.2, 27:1.4, 28:1.5, 29:1.7, 30:1.9, 31:2.1, 32:2.2, 33:2.4, 34:2.6, 35:2.9, 36:3.2, 37:3.5, 38:3.8, 39:4.1, 40:4.5, 41:4.7, 42:5.2, 43:5.6, 44:6.0, 45:7.3, 46:8.2, 47:9.1, 48:10.1, 49:10.9, 50:12.0, 51:12.8, 52:13.4, 53:14.3, 54:16.7, 55:18.3, 56:19.0, 57:21.3, 58:23.6, 59:25.4, 60:27.8, 61:30.1, 62:32.0, 63:34.0, 64:36.0, 65:38.0, 66:41.0, 67:43.0, 68:45.0, 69:48.0, 70:51.0, 71:54.0, 72:57.0, 73:60.0
		},
		'risc_low': {
			0:0, 1:0, 2:0, 3:0, 4:0, 5:0, 6:0, 7:0, 8:0, 9:0, 10:0, 11:0, 12:0, 13:0.1, 14:0.1, 15:0.1, 16:0.1, 17:0.1, 18:0.1, 19:0.2, 20:0.2, 21:0.2, 22:0.2, 23:0.3, 24:0.3, 25:0.3, 26:0.3, 27:0.4, 28:0.4, 29:0.5, 30:0.5, 31:0.5, 32:0.6, 33:0.6, 34:0.7, 35:0.7, 36:0.8, 37:0.8, 38:0.9, 39:1.0, 40:1.1, 41:1.2, 42:1.3, 43:1.4, 44:1.5, 45:1.8, 46:2.1, 47:2.3, 48:2.5, 49:2.8, 50:3.0, 51:3.2, 52:3.4, 53:3.7, 54:4.2, 55:4.6, 56:4.8, 57:5.4, 58:7.9, 59:6.5, 60:6.9, 61:7.5, 62:8.0, 63:8.5, 64:9.0, 65:9.5, 66:10.3, 67:10.8, 68:11.3, 69:12.0, 70:12.8, 71:13.5, 72:14.3, 73:15.0
			}
		 }
	}


# ----------------------------------------------------------------------------


class cTest(mtBase.cTest):
	"""
	Test.
	"""
	def __init__(self,parent):
		mtBase.cTest.__init__(self,parent=parent,template=_test_def,test='procam')
		self.testdisplay = cTestDisplay(self,self.template,self.test)
		self.testhistory = mtBase.cTestHistory(self,self.template,self.test)
		self.AddPage(self.testdisplay,self.test)
		self.AddPage(self.testhistory,'Verlauf')

# --------------------------------------------------------------------------

class cTestDisplay(mtBase.cTestDisplay):
	def __init__(self,parent,template,test):
		mtBase.cTestDisplay.__init__(self,parent,template,test)

	def _refresh_score(self,evt):
		"""
		Get risc and display it.

		"""
		score = self._get_score(self.template[self.test]['index_score'])
		if self.controls['Sex'].GetValue() == 'w' and self.controls['DM'].GetValue() == 1:
			# continue, if score is not defined
			try:
				risc = self.template[self.test]['risc_low'][score]
			except KeyError:
				risc = ''
		else:
			try:
				risc = self.template[self.test]['risc_high'][score]
			except KeyError:
				risc = ''
		self.controls['score'].SetValue(risc)
