#!/usr/bin/env python
# coding: utf-8
# Basismodul für MultiTest 0.3
# Ruthard Baudach
# 13.05.2007

"""
This file defines an sample test.

_test_def defines the test in detail.

cTest is instantiated by mtMain to use this test and has to be defined here, derived from mtBase.cTest.
Classes and funktions that have to be overridden due to none standard evaluation must be defined here.
"""

import wx
import mtBase

_test_def = {
	# index defines the subtests
	'index': [ 'SampleTest' ],
	# definition of subtest "SampleTest"
	'SampleTest': {
		# the caption of the testdisplay
		'caption': 'ProbeTest SAMPLE',
		# index_layout defines how the controls are added to the flexgridsizer forming the questionaire
		'index_layout': [ 'text','item1', 'item2','leer','item3','item4' ],
		# 'index_score defines, which items are used to get the score
		'index_score': [ 'item1', 'item2','item3','item4' ],
		# index_result_layout defines how the controls are added to the boxsizer of the resultdisplay
		'index_result_layout': ['score', 'notice'],
		# index_result defines the actual controls showing the result(s)
		'index_result': ['score'],
		# index_back defines the text returned to the exportfile
		'index_back': [('backnotice','score')],
		# number of rows and columns of the flexgridsizer forming the questionaire
		'size_questionaire': (2,3),
		# number of columns of the flexgridsizer forming the resultdisplay
		'size_resultdisplay': (1,2),
		# testitem 1
		'item1': {
			# type of this item choice of RadioBox, TextInput, TextDisplay, Space, Line
			'type': 'RadioBox',
			# prompt of this control
			'prompt': 'Prompt1',
			# choices of the radiobox
			'choices': [ '0','1','2','3' ],
			# number of columns
			'col': 0,
			# style of the radiobox (see wx.Pyton ocumentation
			'style': wx.RA_SPECIFY_COLS,
			# dictionary containing the table converting the radiobutton choices to score points
			'table': {0:0,1:1,2:2,3:3},
			# by default activated radiobutton
			'default': 0 
			},
		'item2': {
			'type': 'RadioBox',  # Art des Eingabefeldes
			'prompt': 'Prompt2',
			'choices': [ '0','1','2','3' ],
			'col': 0, # number of columns
			'style': wx.RA_SPECIFY_COLS,
			'table': {0:0,1:1,2:2,3:3},  # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			'default': 0 # Voreinstellung
			},
		'leer':{
			'type': 'Space',
			# size of the space
			'size': (20,20),
			},
		'text': {
			'type': 'TextDisplay',
			# text to be displayed
			'text': 'was da wohl steht?',
			'size': (-1,-1)
			},
		'line': {
			'type': 'Line',
			# size (0,x) is horizontal, (x,0) vertical
			'size': (0,200)
			},
		'item3': {
			'type': 'TextInput',
			'prompt': 'Prompt3',
			'size': (30,-1),
			'table': {0:0,1:1,2:2,3:3,4:4} #
			},
		'item4': {
			'type': 'TextInput',
			'prompt': 'Prompt4',
			'size': (30,-1),  #tuple mit Größe des TextCtrl Feldes
			'table': {0:0,1:1,2:2,3:3,4:4} # Wörterbuch mit Zuordnung des gewählten Wertes zu Punkten
			},
		'score': {
			'type': 'TextInput',
			'prompt': 'Score:',
			'size': (30,-1),
			},
		'notice': {
	  		'type': 'TextDisplay',
			'text': 'Hier kann eine Bemerkung zu diesem Test hin,\n zum Beispiel eine Auswertung.\nDieser Text dient jetzt nur als Beispiel.',
			'size': (300,-1),
			},
		# the backnotice(s) are just a string
		'backnotice': 'Diese Nachricht wird an das Praxissystem ausgegeben: '
			
		}
	}
# ---------------------------------------------------------------------------------------------
# Klassendefinitionen
# ---------------------------------------------------------------------------------------------

class cTest(mtBase.cTest):
	"""
	This class represents the test of this module.

	If the test defines own TestDisplay or TestHistory classes the lines:
	
	self.testdisplay = mtBase.cTestDisplay(self,self.template,test)
	self.testhistory = mtBase.cTestHistory(self,self.template,test)

	have to be adopted to the actual tests
	"""
	def __init__(self,parent):
		mtBase.cTest.__init__(self,parent=parent,template=_test_def,test='SampleTest')
		self.testdisplay = mtBase.cTestDisplay(self,self.template,self.test)
		self.testhistory = mtBase.cTestHistory(self,self.template,self.test)
		self.AddPage(self.testdisplay,self.test)
		self.AddPage(self.testhistory,'SampleTest')
