/* 
   Project: SuDoku

   Copyright (C) 2005 Free Software Foundation

   Author: Fred Kiefer

   Created: 2005-06-08 21:09:56 +0200 by fred
   
   Application Controller

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include "AppController.h"

@implementation AppController

+ (void)initialize
{
  NSMutableDictionary *defaults = [NSMutableDictionary dictionary];

  /*
   * Register your app's defaults here by adding objects to the
   * dictionary, eg
   *
   * [defaults setObject:anObject forKey:keyForThatObject];
   *
   */
  
  [[NSUserDefaults standardUserDefaults] registerDefaults:defaults];
  [[NSUserDefaults standardUserDefaults] synchronize];
}

- (id)init
{
  if ((self = [super init]))
    {
    }
  return self;
}

- (void)dealloc
{
  [super dealloc];
}

- (void)awakeFromNib
{
  [[NSApp mainMenu] setTitle:@"Composite"];
  [iv1 setImage: [NSImage imageNamed: @"fosdem"]];
  [iv2 setImage: [NSImage imageNamed: @"GNUstep"]];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotif
{
}

- (BOOL)applicationShouldTerminate:(id)sender
{
  return YES;
}

- (void)applicationWillTerminate:(NSNotification *)aNotif
{
}

- (BOOL)application:(NSApplication *)application openFile:(NSString *)fileName
{
}

- (void)showPrefPanel:(id)sender
{
}

- (void)composite:(id)sender
{
  NSImage *im1;
  NSImage *im2;
  float delta;
  NSCompositingOperation op;

  op = [[radios selectedCell] tag];
  delta = [slider floatValue];
  im1 = [iv1 image];
  im2 = [iv2 image];

  [result lockFocus];
  // Draw the background image
  [im1 compositeToPoint: NSMakePoint(0.0, 0.0) operation: NSCompositeCopy];
  // Composite second image over the first
  [im2 compositeToPoint: NSMakePoint(0.0, 0.0) operation: op fraction: delta];
  [result unlockFocus];
  [[result window] flushWindow];
}

@end
