/* Check basic encodings */
/* Author: David Ayers <d.ayers@inode.at> */
/* { dg-options -fgnu-runtime } */
/* { dg-do run } */

#include <objc/objc.h>
#include <objc/objc-api.h>

#define CHECK_ENC(type,enc) printf("TESTING: %s %s %s = %s \n",(strcmp(enc_##type,(enc)) ? "FAIL" : "PASS" ), (#type), enc_##type, (enc) )

void enc_types (void)
{
  const char *enc_BOOL   = @encode(BOOL);
  const char *enc_char   = @encode(char);
  const char *enc_uchar  = @encode(unsigned char);
  const char *enc_short  = @encode(short);
  const char *enc_ushort = @encode(unsigned short);
  const char *enc_int    = @encode(int);
  const char *enc_uint   = @encode(unsigned int);
  const char *enc_long   = @encode(long);
  const char *enc_ulong  = @encode(unsigned long);
  const char *enc_llong  = @encode(long long);
  const char *enc_ullong = @encode(unsigned long long);
  const char *enc_float  = @encode(float);
  const char *enc_double = @encode(double);
  const char *enc_id     = @encode(id);
  const char *enc_Class  = @encode(Class);
  const char *enc_SEL    = @encode(SEL);

  CHECK_ENC(BOOL,"C");
  CHECK_ENC(char,"c");
  CHECK_ENC(uchar,"C");
  CHECK_ENC(short,"s");
  CHECK_ENC(ushort,"S");
  CHECK_ENC(int,"i");
  CHECK_ENC(uint,"I");
  CHECK_ENC(long,"l");
  CHECK_ENC(ulong,"L");
  CHECK_ENC(llong,"q");
  CHECK_ENC(ullong,"Q");
  CHECK_ENC(float,"f");
  CHECK_ENC(double,"d");
  CHECK_ENC(id,"@");
  CHECK_ENC(Class,"#");
  CHECK_ENC(SEL,":");
}

void enc_ptr_types (void)
{
  const char *enc_BOOL   = @encode(BOOL *);
  const char *enc_char   = @encode(char *);
  const char *enc_uchar  = @encode(unsigned char *);
  const char *enc_short  = @encode(short *);
  const char *enc_ushort = @encode(unsigned short *);
  const char *enc_int    = @encode(int *);
  const char *enc_uint   = @encode(unsigned int *);
  const char *enc_long   = @encode(long *);
  const char *enc_ulong  = @encode(unsigned long *);
  const char *enc_llong  = @encode(long long *);
  const char *enc_ullong = @encode(unsigned long long *);
  const char *enc_float  = @encode(float *);
  const char *enc_double = @encode(double *);

  const char *enc_id     = @encode(id *);
  const char *enc_Class  = @encode(Class *);
  const char *enc_SEL    = @encode(SEL *);

  const char *enc_void   = @encode(void *);

  CHECK_ENC(BOOL,"*");
  CHECK_ENC(char,"*");
  CHECK_ENC(uchar,"*");
  CHECK_ENC(short,"^s");
  CHECK_ENC(ushort,"^S");
  CHECK_ENC(int,"^i");
  CHECK_ENC(uint,"^I");
  CHECK_ENC(long,"^l");
  CHECK_ENC(ulong,"^L");
  CHECK_ENC(llong,"^q");
  CHECK_ENC(ullong,"^Q");
  CHECK_ENC(float,"^f");
  CHECK_ENC(double,"^d");

  CHECK_ENC(id,"^@");
  CHECK_ENC(Class,"^#");
  CHECK_ENC(SEL,"^:");

  CHECK_ENC(void,"^v");
}

void enc_ptr_ptr_types (void)
{
  const char *enc_BOOL   = @encode(BOOL **);
  const char *enc_char   = @encode(char **);
  const char *enc_uchar  = @encode(unsigned char **);
  const char *enc_short  = @encode(short **);
  const char *enc_ushort = @encode(unsigned short **);
  const char *enc_int    = @encode(int **);
  const char *enc_uint   = @encode(unsigned int **);
  const char *enc_long   = @encode(long **);
  const char *enc_ulong  = @encode(unsigned long **);
  const char *enc_llong  = @encode(long long **);
  const char *enc_ullong = @encode(unsigned long long **);
  const char *enc_float  = @encode(float **);
  const char *enc_double = @encode(double **);

  const char *enc_void   = @encode(void **);

  CHECK_ENC(BOOL,"^*");
  CHECK_ENC(char,"^*");
  CHECK_ENC(uchar,"^*");
  CHECK_ENC(short,"^^s");
  CHECK_ENC(ushort,"^^S");
  CHECK_ENC(int,"^^i");
  CHECK_ENC(uint,"^^I");
  CHECK_ENC(long,"^^l");
  CHECK_ENC(ulong,"^^L");
  CHECK_ENC(llong,"^^q");
  CHECK_ENC(ullong,"^^Q");
  CHECK_ENC(float,"^^f");
  CHECK_ENC(double,"^^d");

  CHECK_ENC(void,"^^v");
}



int main ()
{
  enc_types ();
  enc_ptr_types ();
  enc_ptr_ptr_types ();
  return(0);
}
