/* Check basic signatures */
/* Author: David Ayers <d.ayers@inode.at> */
/* { dg-options -fgnu-runtime } */
/* { dg-do run } */

#include <objc/objc.h>
#include <objc/objc-api.h>
#include <objc/Object.h>

#define DECL_SIG(rtype,ptypes) \
  const char *sig_##rtype##_##ptypes \
    = sig_types(cls,@selector(sig_##rtype##_##ptypes));

#define DECL_SIG_P(rtype,ptypes) \
  const char *sig_##rtype##_##ptypes \
    = sig_types(cls,@selector(sig_##rtype##_##ptypes:));

#define CHECK_SIG(rtype,ptypes,sig) \
  printf("TESTING: %s %s %s = %s \n", \
	 (strcmp(sig_##rtype##_##ptypes,(sig)) ? "FAIL" : "PASS" ), \
         #rtype "-" #ptypes, \
	 sig_##rtype##_##ptypes, \
	 (sig) )

typedef struct _small_struct small_struct;
struct _small_struct
{
  long m_long;
};

typedef struct _large_struct large_struct;
struct _large_struct
{
  BOOL         m_BOOL;
  char         m_char;
  short        m_short;
  int          m_int;
  long         m_long;
  float        m_float;
  double       m_double;
  id           m_id;
  Class        m_Class;
  SEL          m_SEL;
  small_struct m_small_struct;
};

@interface Signatures : Object
- (void)sig_void_void;
- (BOOL)sig_BOOL_void;
- (char)sig_char_void;
- (unsigned char)sig_uchar_void;
- (short)sig_short_void;
- (unsigned short)sig_ushort_void;
- (int)sig_int_void;
- (unsigned int)sig_uint_void;
- (long)sig_long_void;
- (unsigned long)sig_ulong_void;
- (long long)sig_llong_void;
- (unsigned long long)sig_ullong_void;
- (float)sig_float_void;
- (double)sig_double_void;
- (id)sig_id_void;
- (Class)sig_Class_void;
- (SEL)sig_SEL_void;

- (small_struct)sig_small_struct_void;
- (large_struct)sig_large_struct_void;

- (void*)sig_voidp_void;
- (BOOL*)sig_BOOLp_void;
- (char*)sig_charp_void;
- (unsigned char*)sig_ucharp_void;
- (short*)sig_shortp_void;
- (unsigned short*)sig_ushortp_void;
- (int*)sig_intp_void;
- (unsigned int*)sig_uintp_void;
- (long*)sig_longp_void;
- (unsigned long*)sig_ulongp_void;
- (long long*)sig_llongp_void;
- (unsigned long long*)sig_ullongp_void;
- (float*)sig_floatp_void;
- (double*)sig_doublep_void;
- (id*)sig_idp_void;
- (Class*)sig_Classp_void;
- (SEL*)sig_SELp_void;


- (void)sig_void_BOOL:(BOOL)p;
- (void)sig_void_char:(char)p;
- (void)sig_void_uchar:(unsigned char)p;
- (void)sig_void_short:(short)p;
- (void)sig_void_ushort:(unsigned short)p;
- (void)sig_void_int:(int)p;
- (void)sig_void_uint:(unsigned int)p;
- (void)sig_void_long:(long)p;
- (void)sig_void_ulong:(unsigned long)p;
- (void)sig_void_llong:(long long)p;
- (void)sig_void_ullong:(unsigned long long)p;
- (void)sig_void_float:(float)p;
- (void)sig_void_double:(double)p;
- (void)sig_void_id:(id)p;
- (void)sig_void_Class:(Class)p;
- (void)sig_void_SEL:(SEL)p;

- (void)sig_void_small_struct:(small_struct)p;
- (void)sig_void_large_struct:(large_struct)p;

@end
@implementation Signatures
- (void)sig_void_void {};
- (BOOL)sig_BOOL_void { return 0; }
- (char)sig_char_void { return 0; }
- (unsigned char)sig_uchar_void { return 0; }
- (short)sig_short_void { return 0; }
- (unsigned short)sig_ushort_void { return 0; }
- (int)sig_int_void { return 0; }
- (unsigned int)sig_uint_void { return 0; }
- (long)sig_long_void { return 0; }
- (unsigned long)sig_ulong_void { return 0; }
- (long long)sig_llong_void { return 0; }
- (unsigned long long)sig_ullong_void { return 0; }
- (float)sig_float_void { return 0; }
- (double)sig_double_void { return 0; }
- (id)sig_id_void { return 0; }
- (Class)sig_Class_void { return 0; }
- (SEL)sig_SEL_void { return 0; }

- (small_struct)sig_small_struct_void { small_struct ss = { 0 }; return ss; }
- (large_struct)sig_large_struct_void
{
  large_struct ls = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, { 0 } };
  return ls;
}

- (void*)sig_voidp_void { return NULL; }
- (BOOL*)sig_BOOLp_void { return NULL; }
- (char*)sig_charp_void { return NULL; }
- (unsigned char*)sig_ucharp_void { return NULL; }
- (short*)sig_shortp_void { return NULL; }
- (unsigned short*)sig_ushortp_void { return NULL; }
- (int*)sig_intp_void { return NULL; }
- (unsigned int*)sig_uintp_void { return NULL; }
- (long*)sig_longp_void { return NULL; }
- (unsigned long*)sig_ulongp_void { return NULL; }
- (long long*)sig_llongp_void { return NULL; }
- (unsigned long long*)sig_ullongp_void { return NULL; }
- (float*)sig_floatp_void { return NULL; }
- (double*)sig_doublep_void { return NULL; }
- (id*)sig_idp_void { return NULL; }
- (Class*)sig_Classp_void { return NULL; }
- (SEL*)sig_SELp_void { return NULL; }

- (void)sig_void_BOOL:(BOOL)p { }
- (void)sig_void_char:(char)p { }
- (void)sig_void_uchar:(unsigned char)p { }
- (void)sig_void_short:(short)p { }
- (void)sig_void_ushort:(unsigned short)p { }
- (void)sig_void_int:(int)p { }
- (void)sig_void_uint:(unsigned int)p { }
- (void)sig_void_long:(long)p { }
- (void)sig_void_ulong:(unsigned long)p { }
- (void)sig_void_llong:(long long)p { }
- (void)sig_void_ullong:(unsigned long long)p { }
- (void)sig_void_float:(float)p { }
- (void)sig_void_double:(double)p { }
- (void)sig_void_id:(id)p { }
- (void)sig_void_Class:(Class)p { }
- (void)sig_void_SEL:(SEL)p { }

- (void)sig_void_small_struct:(small_struct)p { }
- (void)sig_void_large_struct:(large_struct)p { }

@end

extern Method_t search_for_method_in_list(MethodList_t list, SEL op);
const char *sig_types (Class cls, SEL sel)
{
  Method_t meth = search_for_method_in_list(cls->methods, sel);
  return meth->method_types;
}

void chk_sig_types (void)
{
  Class cls = [Signatures class];

  DECL_SIG(BOOL,void);
  DECL_SIG(char,void);
  DECL_SIG(uchar,void);
  DECL_SIG(short,void);
  DECL_SIG(ushort,void);
  DECL_SIG(int,void);
  DECL_SIG(uint,void);
  DECL_SIG(long,void);
  DECL_SIG(ulong,void);
  DECL_SIG(llong,void);
  DECL_SIG(ullong,void);
  DECL_SIG(float,void);
  DECL_SIG(double,void);
  DECL_SIG(id,void);
  DECL_SIG(Class,void);
  DECL_SIG(SEL,void);

  DECL_SIG(small_struct,void);
  DECL_SIG(large_struct,void);

  DECL_SIG_P(void,BOOL);
  DECL_SIG_P(void,char);
  DECL_SIG_P(void,uchar);
  DECL_SIG_P(void,short);
  DECL_SIG_P(void,ushort);
  DECL_SIG_P(void,int);
  DECL_SIG_P(void,uint);
  DECL_SIG_P(void,long);
  DECL_SIG_P(void,ulong);
  DECL_SIG_P(void,llong);
  DECL_SIG_P(void,ullong);
  DECL_SIG_P(void,float);
  DECL_SIG_P(void,double);
  DECL_SIG_P(void,id);
  DECL_SIG_P(void,Class);
  DECL_SIG_P(void,SEL);

  DECL_SIG_P(void,small_struct);
  DECL_SIG_P(void,large_struct);

  CHECK_SIG(BOOL,void,"C8@0:4");
  CHECK_SIG(char,void,"c8@0:4");
  CHECK_SIG(uchar,void,"C8@0:4");
  CHECK_SIG(short,void,"s8@0:4");
  CHECK_SIG(ushort,void,"S8@0:4");
  CHECK_SIG(int,void,"i8@0:4");
  CHECK_SIG(uint,void,"I8@0:4");
  CHECK_SIG(long,void,"l8@0:4");
  CHECK_SIG(ulong,void,"L8@0:4");
  CHECK_SIG(llong,void,"q8@0:4");
  CHECK_SIG(ullong,void,"Q8@0:4");
  CHECK_SIG(float,void,"f8@0:4");
  CHECK_SIG(double,void,"d8@0:4");
  CHECK_SIG(id,void,"@8@0:4");
  CHECK_SIG(Class,void,"#8@0:4");
  CHECK_SIG(SEL,void,":8@0:4");

  CHECK_SIG(small_struct,void,"{_small_struct=l}8@0:4");
  CHECK_SIG(large_struct,void,"{_large_struct=Ccsilfd@#:{_small_struct=l}}8@0:4");

  CHECK_SIG(void,BOOL,"v12@0:4C8");
  CHECK_SIG(void,char,"v12@0:4c8");
  CHECK_SIG(void,uchar,"v12@0:4C8");
  CHECK_SIG(void,short,"v12@0:4s8");
  CHECK_SIG(void,ushort,"v12@0:4S8");
  CHECK_SIG(void,int,"v12@0:4i8");
  CHECK_SIG(void,uint,"v12@0:4I8");
  CHECK_SIG(void,long,"v12@0:4l8");
  CHECK_SIG(void,ulong,"v12@0:4L8");
  CHECK_SIG(void,llong,"v16@0:4q8");
  CHECK_SIG(void,ullong,"v16@0:4Q8");
  CHECK_SIG(void,float,"v12@0:4f8");
  CHECK_SIG(void,double,"v16@0:4d8");
  CHECK_SIG(void,id,"v12@0:4@8");
  CHECK_SIG(void,Class,"v12@0:4#8");
  CHECK_SIG(void,SEL,"v12@0:4:8");

  CHECK_SIG(void,small_struct,"v12@0:4{_small_struct=l}8");
  CHECK_SIG(void,large_struct,"v48@0:4{_large_struct=Ccsilfd@#:{_small_struct=l}}8");
}

int main ()
{
  chk_sig_types ();
  return(0);
}
