/* Advanced signatures */
/* Author: David Ayers <d.ayers@inode.at> */
/* { dg-options -fgnu-runtime } */
/* { dg-do run } */

#include <objc/objc.h>
#include <objc/objc-api.h>
#include <objc/Object.h>

#define DECL_SIG(rq,rt,pq,pt) \
  const char *sig_##rq##_##rt##_##pq##_##pt \
    = sig_types(cls,@selector(sig_##rq##_##rt##_##pq##_##pt));

#define DECL_SIG_P(rq,rt,pq,pt) \
  const char *sig_##rq##_##rt##_##pq##_##pt \
    = sig_types(cls,@selector(sig_##rq##_##rt##_##pq##_##pt:));

#define CHECK_SIG(rq,rt,pq,pt,sig) \
  printf("TESTING: %s %s %s = %s \n", \
	 (strcmp(sig_##rq##_##rt##_##pq##_##pt,(sig)) ? "FAIL" : "PASS" ), \
         #rq " " #rt "-" #pq " " #pt, \
	 sig_##rq##_##rt##_##pq##_##pt, \
	 (sig) )


@interface Signatures : Object
- (oneway void)sig_oneway_void___void;

- (bycopy id)sig_bycopy_id___void;
- (byref id)sig_byref_id___void;

- (void)sig___void_in_id:(in id)p;
- (void)sig___void_out_id:(out id)p;
- (void)sig___void_inout_id:(inout id)p;

- (void)sig___void_bycopy_id:(bycopy id)p;
- (void)sig___void_byref_id:(byref id)p;

- (void)sig___void_bycopyout_id:(bycopy out id)p;

@end
@implementation Signatures
- (oneway void)sig_oneway_void___void { }

- (bycopy id)sig_bycopy_id___void { return nil; }
- (byref id)sig_byref_id___void { return nil; }

- (void)sig___void_in_id:(in id)p { }
- (void)sig___void_out_id:(out id)p { }
- (void)sig___void_inout_id:(inout id)p { }

- (void)sig___void_bycopy_id:(bycopy id)p { }
- (void)sig___void_byref_id:(byref id)p { }

- (void)sig___void_bycopyout_id:(bycopy out id)p { }
@end

extern Method_t search_for_method_in_list(MethodList_t list, SEL op);
const char *sig_types (Class cls, SEL sel)
{
  Method_t meth = search_for_method_in_list(cls->methods, sel);
  return meth->method_types;
}

void chk_sig_types (void)
{
  Class cls = [Signatures class];

  DECL_SIG(oneway,void,_,void);
  DECL_SIG(bycopy,id,_,void);
  DECL_SIG(byref,id,_,void);

  DECL_SIG_P(_,void,in,id);
  DECL_SIG_P(_,void,out,id);
  DECL_SIG_P(_,void,inout,id);

  DECL_SIG_P(_,void,bycopy,id);
  DECL_SIG_P(_,void,byref,id);
  DECL_SIG_P(_,void,bycopyout,id);

  CHECK_SIG(oneway,void,_,void,"Vv8@0:4");
  CHECK_SIG(bycopy,id,_,void,"O@8@0:4");
  CHECK_SIG(byref,id,_,void,"R@8@0:4");

  CHECK_SIG(_,void,in,id,"v12@0:4n@8");
  CHECK_SIG(_,void,out,id,"v12@0:4o@8");
  CHECK_SIG(_,void,inout,id,"v12@0:4N@8");

  CHECK_SIG(_,void,bycopy,id,"v12@0:4O@8");
  CHECK_SIG(_,void,byref,id,"v12@0:4R@8");
  CHECK_SIG(_,void,bycopyout,id,"v12@0:4oO@8");
  
}

int main ()
{
  chk_sig_types ();
  return(0);
}
