//
//  MyClass.m
//  KVOVerification
//
//  Created by Markus Hitter on 14.12.07.
//  Copyright 2007 jump-ING Markus Hitter. All rights reserved.
//

#import "MyClass.h"


@implementation MyClass

- (void)doIt {
  // Different ways to count upwards.
  [self setValue:[NSNumber numberWithInt:1] forKey:@"value"];
  [self setValue:[NSNumber numberWithInt:2]];
  value = 3;
  NSLog(@"Part 1 done.");
  
  // Attempt to set the same value again.
  [self setValue:[NSNumber numberWithInt:3] forKey:@"value"];
  [self setValue:[NSNumber numberWithInt:3]];
  value = 3;

  return;
}

- (void)observeValueForKeyPath:(NSString *)keyPath
                      ofObject:(id)object 
                        change:(NSDictionary *)change
                       context:(void *)context {
  NSLog(@"Key path %@ set to %@", keyPath, [object valueForKeyPath:keyPath]);
  return;
}

- (void)setValue:(NSNumber *)sender {
  value = [sender intValue];
  
  return;
}

- (int)value {
  return value;
}

@end
