#include <Foundation/Foundation.h>

@interface Model : NSObject <NSCoding>
{
  int cint;
  unsigned int cuint;
  NSInteger nsint;
  NSUInteger nsuint;
}
@end
@implementation Model
-(void)setValues
{
  cint = -1234567890;
  cuint = 1234567890;
  nsint = -1234567890;
  nsuint = 1234567890;
}
-(BOOL)isEqual:(id)o
{
  Model *other = o;
  return (cint == other->cint) 
    && (cuint == other->cuint) 
    && (nsint == other->nsint)
    && (nsuint == other->nsuint);
}
-(void)encodeWithCoder:(NSCoder *)coder
{
  [coder encodeValueOfObjCType:@encode(int) at:&cint];
  [coder encodeValueOfObjCType:@encode(unsigned int) at:&cuint];
  [coder encodeValueOfObjCType:@encode(NSInteger) at:&nsint];
  [coder encodeValueOfObjCType:@encode(NSUInteger) at:&nsuint];
}
-(id)initWithCoder:(NSCoder *)coder
{
#if 0
  [coder decodeValueOfObjCType: @encode(int) at: &cint];
  [coder decodeValueOfObjCType: @encode(unsigned int) at: &nsuint];
  [coder decodeValueOfObjCType: @encode(NSInteger) at: &cint];
  [coder decodeValueOfObjCType: @encode(NSUInteger) at: &cuint];
#else
  [coder decodeValueOfObjCType: @encode(NSInteger) at: &cint];
  [coder decodeValueOfObjCType: @encode(NSUInteger) at: &nsuint];
  [coder decodeValueOfObjCType: @encode(int) at: &cint];
  [coder decodeValueOfObjCType: @encode(unsigned int) at: &cuint];
#endif
  return self;
}
@end

int main (int argc, const char *argv[])
{
  id pool = [NSAutoreleasePool new];
  id obj2, obj1 = [Model new];
  NSData *data;

  data = [NSArchiver archivedDataWithRootObject:obj1];
  obj2 = [NSUnarchiver unarchiveObjectWithData:data];
  NSLog(@"%u",(int)[obj1 isEqual:obj2]);
  
  [pool release];
  return (0);
}
