#import <AppKit/AppKit.h>

@interface BarView : NSView
@end

@implementation BarView
- (void) displayRectIgnoringOpacity:(NSRect)aRect
inContext:(id)context
{
  [super displayRectIgnoringOpacity:aRect inContext:context];
  NSLog(@"needs display after display %i", [self needsDisplay]);
}


- (void) drawRect:(NSRect)r
{
  NSRect rect = [self bounds];

  [[NSColor purpleColor] set];
  NSRectFill(r);
}
@end

@interface Foo : NSObject
{
  BarView *bv;
}
@end

@implementation Foo
- (void) redraw:(id)sender
{
  [bv setNeedsDisplay:YES];
}


- (void) applicationDidFinishLaunching:(id)notif
{
  NSWindow *win = [[NSWindow alloc]
	initWithContentRect:NSMakeRect(0,0,700,500)
	styleMask:NSTitledWindowMask|NSClosableWindowMask|NSResizableWindowMask
	backing:NSBackingStoreBuffered
	defer:NO];
  bv = [[BarView alloc] initWithFrame:NSMakeRect(146.7490425, 205.641785, 118, 54)];

  [[win contentView] addSubview:bv];
  [win makeKeyAndOrderFront:self];				
}

@end

int main()
{
  NSAutoreleasePool *pool = [NSAutoreleasePool new];
  Foo *foo = [Foo new];
  NSApplication *app = [NSApplication sharedApplication];
  NSMenu *menu = [NSMenu new];
  
  [menu addItemWithTitle:@"quit" action:@selector(terminate:) keyEquivalent:@"q"];
  [menu addItemWithTitle:@"redraw:" action:@selector(redraw:) keyEquivalent:@"r"];

  [app setMainMenu:menu];
  [app setDelegate:foo];
  [app run];

  [pool release];

  return 0;
}
