#import <AppKit/AppKit.h>

@interface NSView(foo)
- (NSRect) _frameExtend;
@end

@interface FooView : NSView
{
  NSRect pickerRect;
  float resizeInc;
  NSTextField *tf1;
  NSTextField *tf2;
  NSTextField *tf3;
  NSTextField *tf4;
  NSView *watchView;
}
- (void) subviewFrameChanged:(NSView *)sender;
- (void) watchView:(NSView *)sender;
@end

@implementation FooView
- (float) resizeIncrement
{
  return resizeInc;
}
- (void) watchView:(NSView *)object
{
  [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(frameChanged:) name:NSViewFrameDidChangeNotification object:object];
  watchView = object;
  [self subviewFrameChanged:object];
}

- (void) frameChanged:(NSNotification *)notif
{
  [self subviewFrameChanged:[notif object]];
}

- (id) initWithFrame:(NSRect)fr
{
  NSSize tfSize = NSMakeSize(700, 20);
  NSPoint tfPt;

  tfPt.x = fr.origin.x + 2;
  tfPt.y = fr.origin.y + fr.size.height - tfSize.height - 2;


  self = [super initWithFrame:fr];
  tf1 = [[NSTextField alloc] initWithFrame:NSMakeRect(tfPt.x, tfPt.y, tfSize.width, tfSize.height)];
  tfPt.y -= tfSize.height + 2;
  tf2 = [[NSTextField alloc] initWithFrame:NSMakeRect(tfPt.x, tfPt.y, tfSize.width, tfSize.height)];
  tfPt.y -= tfSize.height + 2;
  tf3 = [[NSTextField alloc] initWithFrame:NSMakeRect(tfPt.x, tfPt.y, tfSize.width, tfSize.height)];
  tfPt.y -= tfSize.height + 2;
  tf4 = [[NSTextField alloc] initWithFrame:NSMakeRect(tfPt.x, tfPt.y, tfSize.width, tfSize.height)];

  [tf1 setEditable:NO];
  [tf2 setEditable:NO];
  [tf3 setEditable:NO];
  [tf4 setEditable:NO];

  resizeInc = 1.0f;

  [self addSubview:tf1];
  [self addSubview:tf2];
  [self addSubview:tf3];
  [self addSubview:tf4];
  return self;
}

NSString *GoodNSStringFromRect(NSRect r)
{
  return [NSString stringWithFormat:@"x=%f y=%f w=%f h=%f", r.origin.x, r.origin.y, r.size.width, r.size.height];
}


- (void) subviewFrameChanged:(NSView *)sender
{
	NSRect frameExtend = [sender _frameExtend];
	pickerRect.origin.x = frameExtend.origin.x + frameExtend.size.width + 2;
	pickerRect.origin.y = frameExtend.origin.y + frameExtend.size.height + 2;
	pickerRect.size.width = pickerRect.size.height = 18;
 	

	[tf1 setStringValue:GoodNSStringFromRect([watchView frame])];
	[tf2 setStringValue:GoodNSStringFromRect([watchView bounds])];
	[tf3 setStringValue:GoodNSStringFromRect([watchView _frameExtend])];

}

- (void) setResizeIncrement:(id)sender
{
  resizeInc = [sender floatValue];
  [tf4 setStringValue:[NSString stringWithFormat:@"%f", resizeInc]];
}

- (void) drawRect:(NSRect)r
{
  NSView *subview = watchView;
	NSRect frameExtend = [subview _frameExtend];
	[[NSColor whiteColor] set];
	NSRectFill([self bounds]);

        [[NSColor blackColor] set];
        NSRectFill(pickerRect);

	[[NSColor blackColor] set];
	NSFrameRect([subview frame]);
	[[NSColor redColor] set];
	NSFrameRect(frameExtend);
}

- (void) mouseDown:(NSEvent *)ev
{
  NSPoint origPt = [self convertPoint:[ev locationInWindow] fromView:nil];

  if (NSPointInRect(origPt, pickerRect))
  {
  while ((ev = [NSApp nextEventMatchingMask:NSLeftMouseDraggedMask|NSLeftMouseUpMask untilDate:nil inMode:NSEventTrackingRunLoopMode dequeue:YES]))
    {
      if ([ev type] == NSLeftMouseUp)
	break;
      {
	NSView *view = watchView;
        NSPoint newPt = [self convertPoint:[ev locationInWindow] fromView:nil];
        NSSize frameSize = [view frame].size;
	
        frameSize.width -= (resizeInc * (origPt.x - newPt.x));
	frameSize.height -= (resizeInc * (origPt.y - newPt.y));
	origPt = newPt;

	[view setFrameSize:frameSize];
	[view setNeedsDisplay:YES];
	[self setNeedsDisplay:YES];

      }

    }
  }
}

@end

@interface BarView : NSView
{
  NSSize scaleSize;
  float rotation;
}
@end

@implementation BarView
- (id) initWithFrame:(NSRect)fr
{
  self = [super initWithFrame:fr];

  scaleSize.width = 1.0f;
  scaleSize.height = 1.0f;
  rotation = 0.0f;
  return self;
}

- (void) displayRectIgnoringOpacity:(NSRect)aRect
inContext:(id)context
{
  [super displayRectIgnoringOpacity:aRect inContext:context];
  NSLog(@"needs display after display %i", [self needsDisplay]);
}


- (void) setScaleHeight:(id)sender
{
  NSSize unit = {1.0, 1.0};
  NSSize newScale = scaleSize;
  [self scaleUnitSquareToSize:[self convertSize:unit fromView:nil]];

  newScale.height = [sender floatValue];
  [self scaleUnitSquareToSize:newScale]; 

  
  [self setNeedsDisplay:YES];
  scaleSize = newScale;
}

- (void) setScaleWidth:(id)sender
{
  NSSize unit = {1.0, 1.0};
  NSSize newScale = scaleSize;
  [self scaleUnitSquareToSize:[self convertSize:unit fromView:nil]];
  newScale.width = [sender floatValue];
  [self scaleUnitSquareToSize:newScale]; 
  [self setNeedsDisplay:YES];
  scaleSize = newScale;
}

- (void) setRotation:(id)sender
{
  [self setFrameRotation:[sender floatValue]];

  [self setNeedsDisplay:YES];
}

/*
 * this isn't strictly needed to reproduce the bug, it just
 * allows one to see that the bug appears and disappears depending on
 * the placement of the view
 */
 
- (void) mouseDown:(NSEvent *)ev
{
  FooView *superView = (FooView *)[self superview];
  NSPoint framePt = [superView convertPoint:[ev locationInWindow] fromView:nil];
  float offsetX = framePt.x - _frame.origin.x;
  float offsetY = framePt.y - _frame.origin.y;


  while ((ev = [NSApp nextEventMatchingMask:NSLeftMouseDraggedMask|NSLeftMouseUpMask untilDate:nil inMode:NSEventTrackingRunLoopMode dequeue:YES]))
    {
      if ([ev type] == NSLeftMouseUp)
	break;


      {
      	 NSPoint newPt = [superView convertPoint:[ev locationInWindow] fromView:nil];

	 newPt.x -= offsetX;
	 newPt.y -= offsetY;

	 if (newPt.x < 1.0) newPt.x = 1.0;
	 if (newPt.y < 1.0) newPt.y = 1.0;

         [self setFrameOrigin:newPt];
	 framePt = newPt;
	 [self autoscroll:ev];

	 [superView setNeedsDisplay:YES];
	 [self setNeedsDisplay:YES];
      }
    }
}

- (void) drawRect:(NSRect)r
{
  NSRect rect = [self bounds];

  [[NSColor purpleColor] set];
  NSRectFill(r);
  [[NSColor yellowColor] set];
  DPSmoveto(GSCurrentContext(), NSMinX(rect),NSMinY(rect));
  DPSlineto(GSCurrentContext(), NSMaxX(rect),NSMaxY(rect));
  DPSclosepath(GSCurrentContext());
  DPSstroke(GSCurrentContext());

  [[NSColor greenColor] set];
  DPSmoveto(GSCurrentContext(), NSMinX(rect),NSMaxY(rect));
  DPSlineto(GSCurrentContext(), NSMaxX(rect),NSMinY(rect));
  DPSclosepath(GSCurrentContext());
  DPSstroke(GSCurrentContext());


  [[NSColor blueColor] set];
  DPSmoveto(GSCurrentContext(), NSMidX(rect), NSMinY(rect));
  DPSlineto(GSCurrentContext(), NSMidX(rect), NSMaxY(rect));
  DPSclosepath(GSCurrentContext());
  DPSstroke(GSCurrentContext());

  [[NSColor redColor] set];
  DPSmoveto(GSCurrentContext(), NSMinX(rect), NSMidY(rect));
  DPSlineto(GSCurrentContext(), NSMaxX(rect), NSMidY(rect));
  DPSclosepath(GSCurrentContext());
  DPSstroke(GSCurrentContext());
}
@end

@interface Foo : NSObject
{
  BarView *bv;
  FooView *fv;
}
@end

@implementation Foo
- (void) redraw:(id)sender
{
  [fv setNeedsDisplay:YES];
  [bv setNeedsDisplay:YES];
}


- (void) applicationDidFinishLaunching:(id)notif
{
  NSWindow *win = [[NSWindow alloc]
	initWithContentRect:NSMakeRect(0,0,700,500)
	styleMask:NSTitledWindowMask|NSClosableWindowMask|NSResizableWindowMask
	backing:NSBackingStoreBuffered
	defer:NO];
  NSSlider *slider = [[NSSlider alloc] initWithFrame:NSMakeRect(0,0, 700, 16)];
  NSSlider *slider2 = [[NSSlider alloc] initWithFrame:NSMakeRect(0,18, 700, 16)];
  NSSlider *slider3 = [[NSSlider alloc] initWithFrame:NSMakeRect(0,36, 700, 16)];
  NSSlider *slider4 = [[NSSlider alloc] initWithFrame:NSMakeRect(0,54, 700, 16)];

  [slider setTitle:@"scale hidth"];
  [slider2 setTitle:@"scale height"];
  [slider3 setTitle:@"rotation"];
  [slider4 setTitle:@"resize increment"];

 
  fv = [[FooView alloc] initWithFrame:NSMakeRect(0,0,700,500)];
  bv = [[BarView alloc] initWithFrame:NSMakeRect(146.7490425, 205.641785, 118, 54)];

  [slider setTarget:bv];
  [slider2 setTarget:bv];
  [slider3 setTarget:bv];
 
  [slider4 setTarget:fv];

  [slider setAction:@selector(setScaleWidth:)];
  [slider2 setAction:@selector(setScaleHeight:)];
  [slider3 setAction:@selector(setRotation:)];
  [slider4 setAction:@selector(setResizeIncrement:)];

  [slider setMinValue:0.1];
  [slider2 setMinValue:0.1];
  [slider3 setMinValue:0.0];
  [slider4 setMinValue:0.0];
  

  [slider setMaxValue:100.0];
  [slider2 setMaxValue:100.0];
  [slider3 setMaxValue:360.0];
  [slider4 setMaxValue:1.0];
  [slider setObjectValue:[NSNumber numberWithFloat:1.0f]];
  [slider2 setObjectValue:[NSNumber numberWithFloat:1.0f]];
  [slider3 setObjectValue:[NSNumber numberWithFloat:0.0f]];
  [slider4 setObjectValue:[NSNumber numberWithFloat:1.0f]];
 
  [bv setPostsFrameChangedNotifications:YES];
  [fv addSubview:bv]; 
  [[win contentView] addSubview:fv];
  [fv watchView:bv];

  [[win contentView] addSubview:slider];
  [[win contentView] addSubview:slider2];
  [[win contentView] addSubview:slider3];
  [[win contentView] addSubview:slider4];
  [win makeKeyAndOrderFront:self];				
}

@end

int main()
{
  NSAutoreleasePool *pool = [NSAutoreleasePool new];
  Foo *foo = [Foo new];
  NSApplication *app = [NSApplication sharedApplication];
  NSMenu *menu = [NSMenu new];
  
  [menu addItemWithTitle:@"quit" action:@selector(terminate:) keyEquivalent:@"q"];
  [menu addItemWithTitle:@"redraw:" action:@selector(redraw:) keyEquivalent:@"r"];

  [app setMainMenu:menu];
  [app setDelegate:foo];
  [app run];

  [pool release];

  return 0;
}
