#!/bin/sh

ANDROID_NDK="/Users/manu/Projets/Android/android-ndk-r8d/"

BUILDROOT=`pwd`
ARMSYSROOT=$BUILDROOT/toolchain-arm

# SVN build version of clang
# CLANG_ARM=$ARMSYSROOT/bin/arm-linux-androideabi-clang
# CLANGPP_ARM=$ARMSYSROOT/bin/arm-linux-androideabi-clang++

# NDK version of clang
CLANG_ARM=$ARMSYSROOT/bin/clang
CLANGPP_ARM=$ARMSYSROOT/bin/clang++

GCC_ARM=$ARMSYSROOT/bin/arm-linux-androideabi-gcc
LD_ARM=$ARMSYSROOT/bin/arm-linux-androideabi-ld

GXX_ARM=$ARMSYSROOT/bin/arm-linux-androideabi-g++

AR_ARM=$ARMSYSROOT/bin/arm-linux-androideabi-ar
RANLIB_ARM=$ARMSYSROOT/bin/arm-linux-androideabi-ranlib
OBJDUMP_ARM=$ARMSYSROOT/bin/arm-linux-androideabi-objdump

SYSROOTFLAGS_ARM="--sysroot $ARMSYSROOT/sysroot"

checkError()
{
    if [ "${1}" -ne "0" ]; then
        echo "*** Error: ${2}"
        exit ${1}
    fi
}

buildLLVM()
{
    if [ ! -d llvm ]; then
        svn co http://llvm.org/svn/llvm-project/llvm/trunk llvm

        cd llvm/tools
        svn co http://llvm.org/svn/llvm-project/cfe/trunk clang
    fi
    cd $BUILDROOT/llvm
    ./configure --prefix=$ARMSYSROOT --enable-optimized --enable-targets=arm --target=arm-linux-androideabi
    make -j4 install

    checkError $? "Make install llvm failed"

    cd $BUILDROOT
}

buildObjC2()
{
    if [ ! -d libobjc2 ]; then
        svn co http://svn.gna.org/svn/gnustep/libs/libobjc2/trunk libobjc2

        cd libobjc2

        # apply patches
        patch -p0 -i ../libobjc2_lock_h.patch

        # already in SVN
        # patch -p0 -i ../libobjc2_unwind-arm.patch

        # build and install only libobjc.a
        # patch -p0 -i ../libobjc2_Makefile_static_only.diff

        patch -p0 -i ../libobjc2_SONAME.patch

        # debuging patches
        # patch -p0 -i ../libobjc_debug_exception.patch
        # patch -p0 -i ../libobjc2_Makefile_debug.patch
    else
        cd libobjc2
        make -f Makefile clean
    fi

    LD="$LD_ARM" LDFLAGS="--sysroot $ARMSYSROOT/sysroot" CC="$CLANG_ARM" CFLAGS="$SYSROOTFLAGS_ARM -I$ARMSYSROOT/sysroot/usr/include" CXX="$CLANGPP_ARM" CXXFLAGS="$SYSROOTFLAGS_ARM" \
    ASMFLAGS="" PREFIX="$ARMSYSROOT/sysroot/usr" make -f Makefile install
    checkError $? "Make install libobjc2 failed"

    cd $BUILDROOT
}

buildGNUstepMake()
{
    echo "Build GNUstep Makefiles"

    if [ ! -f gnustep-make-2.6.2.tar.gz ]; then
        curl ftp://ftp.gnustep.org/pub/gnustep/core/gnustep-make-2.6.2.tar.gz > gnustep-make-2.6.2.tar.gz
    fi
    tar -xzf gnustep-make-2.6.2.tar.gz

    cp tools/config/config.sub gnustep-make-2.6.2
    cp tools/config/config.guess gnustep-make-2.6.2

    cd gnustep-make-2.6.2

    patch -p1 -i ../gsmake_target.patch

    CC="$CLANG_ARM" CXX="$CLANGPP_ARM" CPPFLAGS="$SYSROOTFLAGS_ARM" CFLAGS="$SYSROOTFLAGS_ARM" AR="$AR_ARM" ./configure --prefix=$ARMSYSROOT/sysroot/usr --host="arm-linux-androideabi"
    checkError $? "configure gnustep-make failed"

    make install
    checkError $? "Make install gnutsep-make failed"

    cd $BUILDROOT
}

buildFFI()
{
if [ ! -f $ARMSYSROOT/sysroot/usr/lib/libffi.a ]; then
    echo "Building libffi"

    if [ ! -d libffi ]; then
        git clone git://github.com/atgreen/libffi.git
    fi

    cp tools/config/config.sub libffi
    cp tools/config/config.guess libffi

    cd libffi

    patch -p1 -i ../libffi_closures.patch

    patch -p0 -i ../libffi-include-Makefile_am.patch
    aclocal
    automake

    CC="$CLANG_ARM" CXX="$CLANGPP_ARM" CPPFLAGS="$SYSROOTFLAGS_ARM" CFLAGS="$SYSROOTFLAGS_ARM" AR="$AR_ARM" OBJDUMP="$OBJDUMP_ARM" RANLIB="$RANLIB_ARM" ./configure --prefix=$ARMSYSROOT/sysroot/usr --host="arm-linux-androideabi" --with-sysroot=$ARMSYSROOT/sysroot --disable-shared

    checkError $? "configure libffi failed"

    make install
    checkError $? "Make install libffi failed"
    cd $BUILDROOT
fi
}

buildGNUstepDependencies()
{
    buildFFI

if [ ! -f $ARMSYSROOT/sysroot/usr/lib/libxml2.a ]; then
    echo "Building libxml2"

    if [ ! -f libxml2-2.9.0.tar.gz ]; then
        curl ftp://xmlsoft.org/libxml2/libxml2-2.9.0.tar.gz > libxml2-2.9.0.tar.gz
    fi
    tar -xzf libxml2-2.9.0.tar.gz

    cd libxml2-2.9.0

    # remove tests that needs glob.h
    patch -p1 -i ../libxml2_tests.patch

    # build with gcc instead of clang
    # using clang produce an error missing symbol 'nan'
    CC="$GCC_ARM" LD="$LD_ARM" CXX="$CLANGPP_ARM" CPPFLAGS="$SYSROOTFLAGS_ARM" CFLAGS="$SYSROOTFLAGS_ARM" AR="$AR_ARM" OBJDUMP="$OBJDUMP_ARM" RANLIB="$RANLIB_ARM" ./configure --prefix=$ARMSYSROOT/sysroot/usr --host="arm-linux-androideabi" --with-sysroot=$ARMSYSROOT/sysroot --disable-shared
    checkError $? "configure libxml2 failed"

    make install
    checkError $? "Make install libxml2 failed"
    cd $BUILDROOT
fi

}

buildGNUstepBase()
{
    if [ ! -f gnustep-base-1.24.0.tar.gz ]; then
        curl ftp://ftp.gnustep.org/pub/gnustep/core/gnustep-base-1.24.0.tar.gz > gnustep-base-1.24.0.tar.gz
    fi
    tar -xzf gnustep-base-1.24.0.tar.gz

    cp tools/config/config.sub gnustep-base-1.24.0
    cp tools/config/config.guess gnustep-base-1.24.0

    cd gnustep-base-1.24.0

    patch -p1 -i ../gsbase_configure_ac.patch
    autoconf

    CC="$CLANG_ARM" CXX="$CLANGPP_ARM" CPPFLAGS="$SYSROOTFLAGS_ARM" CFLAGS="$SYSROOTFLAGS_ARM" ./configure --prefix=$ARMSYSROOT/sysroot/usr --host="arm-linux-androideabi" --enable-nxconstantstring -disable-xslt --disable-tls --with-xml-prefix=$ARMSYSROOT/sysroot/usr
    checkError $? "configure gnustep-base failed"

    # patches to build gnustep-base-1.24.0 with libxml2-2.90.0 patch from [bug #37609] (fixed in svn)
    patch -p0 -i ../patch-af

    # android define an empty struct lconv
    patch -p1 -i ../gsbase_GSLocale.patch

    # android dosen't define pw_gecos
    patch -p1 -i ../gsbase_NSPathUtilities.patch 

    patch -p1 -i ../gsbase_FNDELAY.patch

    # don't build SSL Tools and Tests subprojects
    patch -p1 -i ../gsbase_GNUmakefile.patch

    # android don't have nan
    patch -p1 -i ../gsbase_NSDate.patch

    make install
    checkError $? "Make install gnustep-base failed"

    cd $BUILDROOT
}

if [ ! -d $ARMSYSROOT ]; then
    $ANDROID_NDK/build/tools/make-standalone-toolchain.sh --platform=android-14 --install-dir=$ARMSYSROOT --arch=arm --llvm-version=3.1
fi

#if [ ! -f $CLANG_ARM ]; then
#   buildLLVM
#fi

if [ ! -f $ARMSYSROOT/sysroot/usr/lib/libobjc.a ]; then
    buildObjC2
fi

if [ ! -d tools/config ]; then
    git clone http://git.savannah.gnu.org/r/config.git/ tools/config
fi

if [ ! -f $ARMSYSROOT/sysroot/usr/share/GNUstep/Makefiles/GNUstep.sh ]; then
    buildGNUstepMake
fi

. $ARMSYSROOT/sysroot/usr/share/GNUstep/Makefiles/GNUstep.sh

buildGNUstepDependencies

buildGNUstepBase

# buildOpenCFLite

# buildGNUstepCoreBase

