#import "AppController.h"

@implementation AppController

- (id) init
{
  self = [super init];

  if(!self)
    return nil;
  
  //Add here your initializations

  return self;
}

- (void) dealloc
{
  [super dealloc];
}

- (void) awakeFromNib
{
  NSToolbar *bar = [[NSToolbar alloc] initWithIdentifier: @"MyToolBar"];
  [bar setDelegate: self];
  [bar setVisible: YES];
  [window setToolbar: bar];
  [bar release];
}

- (NSArray *) toolbarDefaultItemIdentifiers: (NSToolbar *) toolbar
{
   return [NSArray arrayWithObjects: @"MyItem", nil];
}

- (NSArray *) toolbarAllowedItemIdentifiers: (NSToolbar *) toolbar
{
   return [NSArray arrayWithObjects: @"MyItem", nil];
}

- (NSToolbarItem*) toolbar: (NSToolbar*)toolbar itemForItemIdentifier:
   (NSString*)itemIdentifier willBeInsertedIntoToolbar: (BOOL)flag
{
  NSToolbarItem *toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:
                                                                      itemIdentifier] autorelease];
  
  if([itemIdentifier isEqual: @"MyItem"])
    {
      [toolbarItem setLabel: @"Open"];
      [toolbarItem setImage: [NSImage imageNamed:@"page_landscape"]];
      [toolbarItem setTarget: self];
      [toolbarItem setAction: @selector(open:)];
    }
  return toolbarItem;
}

- (void) open: (id)sender
{
  [[NSOpenPanel openPanel] runModal];
}

- (void)applicationWillFinishLaunching: (NSNotification *)aNotification
{
}

- (void) applicationDidFinishLaunching: (NSNotification *)aNotif
{
}

- (BOOL) applicationShouldTerminate: (id)sender
{
  return YES;
}

- (void) applicationWillTerminate: (NSNotification *)aNotif
{
}

@end
