#import <Foundation/Foundation.h>
#import <WebServer/WebServer.h>

BOOL done = NO;

@interface Delegate : NSObject
{
}
/* WebServer delegate */
- (BOOL) processRequest: (GSMimeDocument*)request
               response: (GSMimeDocument*)response
                    for: (WebServer*)http;
/* end of WebServer delegate */

/* NSURLConnection delegate */
- (void)connectionDidFinishLoading:(NSURLConnection *)connection;
- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error;
/* end of NSURLConnection delegate */
@end

@implementation Delegate
{
}
/* WebServer delegate */
- (BOOL) processRequest: (GSMimeDocument*)request
               response: (GSMimeDocument*)response
                    for: (WebServer*)http
{
  return YES;
}
/* end of WebServer delegate */
/* NSURLConnection delegate */
- (void)connectionDidFinishLoading:(NSURLConnection *)connection
{
  NSLog(@"FINISH");
  done = YES;
}
- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error
{
  NSLog(@"ERROR: %@", error);
  done = YES;
}
/* end of NSURLConnection delegate */
@end

int main(int argc, char **argv, char **env) {
  NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
  NSTimeInterval timing = 0.1;
  NSString *urlString = @"http://127.0.0.1:1975";
  NSURLRequest *req = [NSURLRequest requestWithURL: [NSURL URLWithString: urlString]];
  Delegate *del = [[Delegate new] autorelease];
  WebServer *server = [WebServer new]; 
  [server setDelegate: del];
  [server setAddress: @"127.0.0.1" port: @"1975" secure: nil];

  NSURLConnection *conn = [NSURLConnection connectionWithRequest: req
							delegate: del];
  NSLog(@"CONNECTON to: %@ by: %@", urlString, [conn class]);
  while(!done) {
    [[NSRunLoop currentRunLoop] runUntilDate: [NSDate dateWithTimeIntervalSinceNow: timing]];
  }

  [server setAddress: nil port: nil secure: nil];
  DESTROY(server);
  DESTROY(pool);

  return 0;
}
