#import <Foundation/Foundation.h>
#import <WebServer/WebServer.h>

BOOL done = NO;

@interface Delegate : NSObject
{
}
// for NSTimer
- (void)doNothing:(id)nothing;

/* WebServer delegate */
- (BOOL) processRequest: (GSMimeDocument*)request
               response: (GSMimeDocument*)response
                    for: (WebServer*)http;
/* end of WebServer delegate */

/* NSURLConnection delegate */
- (void)connectionDidFinishLoading:(NSURLConnection *)connection;
- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error;
/* end of NSURLConnection delegate */
@end

@implementation Delegate

- (void)doNothing:(id)nothing
{
  // do nothing
}

/* WebServer delegate */
- (BOOL) processRequest: (GSMimeDocument*)request
               response: (GSMimeDocument*)response
                    for: (WebServer*)http
{
  return YES;
}
/* end of WebServer delegate */
/* NSURLConnection delegate */
- (void)connectionDidFinishLoading:(NSURLConnection *)connection
{
  NSLog(@"FINISH");
  done = YES;
}
- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error
{
  NSLog(@"ERROR: %@", error);
  done = YES;
}
/* end of NSURLConnection delegate */
@end

int main(int argc, char **argv, char **env) {
  NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
  NSTimeInterval timing = 0.1;
  NSTimeInterval pause = 3.0;
  NSString *urlString = @"http://127.0.0.1:1975";
  NSURLRequest *req = [NSURLRequest requestWithURL: [NSURL URLWithString: urlString]];
  Delegate *del = [[Delegate new] autorelease];
  WebServer *server = [WebServer new]; 
  BOOL status;
  NSURLConnection *conn;

  // first start of WebServer
  [server setDelegate: del];
  status = [server setAddress: @"127.0.0.1" port: @"1975" secure: nil];
  if(status)
    {

      conn = [NSURLConnection connectionWithRequest: req
					   delegate: del];

      NSLog(@"CONNECTON1 to: %@ by: %@", urlString, [conn class]);
      while(!done) {
	[[NSRunLoop currentRunLoop] runUntilDate: [NSDate dateWithTimeIntervalSinceNow: timing]];
      }

      [server setAddress: nil port: nil secure: nil];
      DESTROY(server);
    }
  else
    {
      NSLog(@"ERR: can't run WebServer1");
    }

  // pause by scheduling the NSTimer for run loop
  NSLog(@"wait %f seconds", pause);
  [NSTimer scheduledTimerWithTimeInterval: [[NSDate distantFuture] timeIntervalSinceNow]
				   target: del
				 selector: @selector(doNothing:)
				 userInfo: nil
				  repeats: YES];
  [[NSRunLoop currentRunLoop] runUntilDate: [NSDate dateWithTimeIntervalSinceNow: pause]];

  // second start of WebServer
  server = [WebServer new]; 
  [server setDelegate: del];
  status = [server setAddress: @"127.0.0.1" port: @"1975" secure: nil];
  if(status)
    {
      conn = [NSURLConnection connectionWithRequest: req
					   delegate: del];
      NSLog(@"CONNECTON2 to: %@ by: %@", urlString, [conn class]);
      while(!done) {
	[[NSRunLoop currentRunLoop] runUntilDate: [NSDate dateWithTimeIntervalSinceNow: timing]];
      }
      
      [server setAddress: nil port: nil secure: nil];
      DESTROY(server); // here i get NSInternalInconsistencyException
    }
  else
    {
      NSLog(@"ERR: can't run WebServer2");
    }

  DESTROY(pool);

  return 0;
}
