import webapp2
from google.appengine.api import backends
from google.appengine.api.logservice import logservice
import cloudstorage
import logging

class StartHandler(webapp2.RequestHandler):
    
    GCS_BUCKET="/"

    def debugMessage(self, msg):
        logging.debug(msg)
        logservice.flush()        

    def get(self):
        
        suffix = str(backends.get_instance())
        filename=self.GCS_BUCKET + "/testwrite" + suffix + ".txt"

        gcs_file = cloudstorage.open(filename, 'w', content_type='text/plain' )
        self.debugMessage("opened file")
        gcs_file.write("f" * 1024 * 1024 * 1 + '\n') 
        self.debugMessage("data written")
        gcs_file.close()
        self.debugMessage("file closed")
        self.response.write("done. Uploaded file with suffix: " + suffix)
                
app = webapp2.WSGIApplication([
    ('/_ah/start', StartHandler),
], debug=True)

