package com.test.sample.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

import com.test3.event.*;
import com.test3.client.StateCity;

public class TestContainer extends Composite
{
	private static TestContainerUiBinder uiBinder = GWT.create(TestContainerUiBinder.class);

	interface TestContainerUiBinder extends UiBinder<Widget, TestContainer> {}

	@UiField StateCity stateCity;

	public TestContainer() {
		initWidget(uiBinder.createAndBindUi(this));
		stateCity.setStates(getStates());
	}

	@UiHandler("stateCity")
	void onStateChange2(StateChange2Event e)
	{
		if ( e.evType == StateChange2Event.StateCityEventType.StateChanged ) {
			stateCity.setCities(getCities(e.newValue));
		}
		else if ( e.evType == StateChange2Event.StateCityEventType.Done ) {
			Window.alert("Done");
		}
	}

	private List<String> getStates ()
	{
		ArrayList<String> list = new ArrayList<String>();
		list.add("... Select a state ...");
		list.add("MA");
		list.add("NH");
		return list;
	}
	
	private List<String> getCities (String state)
	{
		ArrayList<String> list = new ArrayList<String>();
		list.add("... Select a city ...");
		if ( state.contains("...")) {
		}
		else if ( state.equals("MA")) {
			list.add("Cambridge");
			list.add("Boston");
		}
		else if ( state.equals("NH")) {
			list.add("Nashua");
			list.add("Salem");
		}
		return list;
	}
}
