#  Encapsulated PostScript
#       grops itself doesn't emit bounding box information.  With the  help  of
#       GhostScript the following commands will produce an encapsulated PS file
#       foo.eps from input file foo:

groff -Tps -P-b16 foo > foo.ps
gs -dNOPAUSE -sDEVICE=bbox -- foo.ps 2> foo.bbx
cat foo.ps | sed -e '/^%!PS-Adobe-3.0/s/$/ EPSF-3.0/' -e '/^%%Orientation/rfoo.bbx' > foo.eps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pdfwrite -sOutputFile=foo.pdf foo.eps quit.ps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pngmono -r1200 -sOutputFile=foo.png foo.eps quit.ps
pdfinfo foo.pdf > foo.txt
ps2epsi foo.ps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pdfwrite -sOutputFile=foo_i.pdf foo.epsi quit.ps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pngmono -r1200 -sOutputFile=foo_i.png foo.epsi quit.ps
pdfinfo foo_i.pdf > foo_i.txt
#rm foo.bbx
