#!/usr/bin/perl -w
#
#	PL-show.pl	: Display PDF structure
#	Deri James	: Thursday 17 December 2009
#

use strict;
use ParsePDF;

$"=' ';
my $fn=shift;
my $id=0;
my $pdf=LoadPDF($fn,0);
my (@path)=split('/',$fn);
my $node=pop(@path);
my $lastkey='';

MMpdf($pdf,$node);

sub MMpdf
{
	my $pdf=shift;
	my $node=shift;
	my $rt=0;
	
	my $root=bless(\$rt,'OBJREF');

	print qq(<map version="0.9.0">\n<!-- To view this file, download free mind mapping software FreeMind from http://freemind.sourceforge.net -->\n);

	showval($root,$node);

	print "</map>\n";
}

sub showobj
{
	my $obj=shift;

	foreach my $key (sort keys %{$obj->{OBJ}})
	{
		my $val=$obj->{OBJ}->{$key};
		printnode($key,'>');
		showval($val);
	}

	if (exists($obj->{STREAMPOS}))
	{
		printnode("stream",'/>');
	}
}

sub showval
{
	my $val=shift;
	my $nm=shift;
	my $refval=ref($val);
	
	if ($refval eq 'OBJREF')
	{
		my $obj=$pdf->[$$val];
		$nm="$$val 0 R" if !defined($nm);
		
		if (!exists($obj->{SHOW}))
		{
			$obj->{SHOW}=sprintf("ID_%09d",$id+1);
			my $fold=0;
			$fold=1 if ref($obj->{OBJ}) eq 'HASH' and exists($obj->{OBJ}->{Type}) and $obj->{OBJ}->{Type} eq '/Page';

			printnode("$nm",'>',1,$fold);
			showval($obj->{OBJ});

			if (exists($obj->{STREAMPOS}))
			{
				printnode("stream",'/>');
			}

			print "</node>\n";
		}
		else
		{
			if ($lastkey eq "Parent")
			{
				printnode($nm,'/>');
			}
			else
			{
				printnode($nm,'>');
				my $link=$obj->{SHOW};
				my $id=sprintf("ID_%09d",++$id);
				print qq(<arrowlink DESTINATION="$link" ENDARROW="Default" ENDINCLINATION="237;0;" ID="Arrow_$id" STARTARROW="None" STARTINCLINATION="237;0;"/>\n);
				print "</node>\n";
			}
			
		}
	}
	elsif ($refval eq 'ARRAY')
	{
		my $cnt=0;

		foreach my $cell (@{$val})
		{
			$cnt++;
			showval($cell) if $cnt <= 6 or ref($cell) eq 'OBJREF';
		}

		showval('...') if $cnt > 6;
	}
	elsif ($refval eq 'HASH')
	{
		foreach my $key (sort { ($a eq "Pages")?-1:($b eq "Pages"?1:$a cmp $b) } keys %{$val})
		{
			my $val2=$val->{$key};
			$lastkey=$key;
			printnode("/$key",'>');
			showval($val2);
			print "</node>\n";
		}
	}
	else
	{
		$val=substr($val,0,25)." ..." if length($val) > 30;
		printnode($val,'/>');
	}
	
}

sub printnode
{
	my $txt=shift;
	my $term=shift;
	my $col=shift;
	my $fold=shift;
	my $tm=time();
	my $id=sprintf("ID_%09d",++$id);
	my $colnm='';
	$colnm='COLOR="#0033ff" ' if $col;
	$colnm='FOLDED="true" ' if $fold;

	$txt=~s/&/&amp;/g;
	$txt=~s/</&lt;/g;
	$txt=~s/>/&gt;/g;
	$txt=~s/"/&quot;/g;

	print qq(<node ${colnm}CREATED="$tm" ID="$id" MODIFIED="$tm" TEXT="$txt"$term\n);
}

