/*      bit_vector.h
 *
 * Copyright (C) 2006, 2007, 2008 Ivo Alxneit
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifndef __BIT_VECTOR_H__
#define __BIT_VECTOR_H__

#include <stdlib.h>



struct bit_vector
{
  size_t len;                   /* index of highest bit (0..len) we have
                                   currently memory allocated for. */
  int *v;                       /* memory holding the data. we allocate
                                   in chunks of integers, initially only
                                   one integer holding bit_0 .. bit_n.
                                   n=8*sizeof(int)-1. */
  int implied_bits;             /* bits not held in memory (bit_n+1 ...)
                                   are either all set (1) or unset (0). the
                                   implied value ist stored in implied_bits. */
};

extern struct bit_vector *bit_vector_init (void);
extern struct bit_vector *bit_vector_init_all_set (void);
extern void bit_vector_free (struct bit_vector *);
extern int bit_vector_set_bit (struct bit_vector *, const size_t bit);
extern int bit_vector_clear_bit (struct bit_vector *, const size_t bit);
extern int bit_vector_test_bit (const struct bit_vector *, const size_t bit);



#endif /* __BIT_VECTOR_H__ */
