/*      bit_vector_shift.c
 *
 * Copyright (C) 2008 Ivo Alxneit
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "bit_vector_shift.h"
#include "bit_vector_util.h"

inline struct bit_vector *
bit_vector_shift (struct bit_vector *bv, const int n)
{

  if (n > 0)
    return bit_vector_rshift (bv, (size_t) n);
  else
    return bit_vector_lshift (bv, (size_t) - n);

}


struct bit_vector *
bit_vector_lshift (struct bit_vector *bv, const size_t n)
{
  size_t i, j;
  int status;

  struct bit_vector *result;

  result = bit_vector_copy (bv);
  if (result == NULL)
    return NULL;

  for (i = 0, j = n; i <= bv->len; i++, j++)
    {

      if (bit_vector_test_bit (bv, j))
        status = bit_vector_set_bit (result, i);
      else
        status = bit_vector_clear_bit (result, i);

      if (status)
        {
          bit_vector_free (result);
          return NULL;
        }

    }

  return result;

}


struct bit_vector *
bit_vector_rshift (struct bit_vector *bv, const size_t n)
{
  size_t i, j;
  int status;

  struct bit_vector *result;

  result = bit_vector_copy (bv);
  if (result == NULL)
    return NULL;

  for (i = 0; i < n; i++)
    {
      status = bit_vector_clear_bit (result, i);

      if (status)
        {
          bit_vector_free (result);
          return NULL;
        }

    }

  for (i = n, j = 0; j <= bv->len; i++, j++)
    {

      if (bit_vector_test_bit (bv, j))
        status = bit_vector_set_bit (result, i);
      else
        status = bit_vector_clear_bit (result, i);

      if (status)
        {
          bit_vector_free (result);
          return NULL;
        }

    }

  return result;

}
