#ifndef GSL_VECTOR_H_INCLUDED
#define GSL_VECTOR_H_INCLUDED

#include <gsl_marray.h>


typedef  gsl_const_marray_1_impl  gsl_const_vector_impl;
typedef  gsl_marray_1_impl        gsl_vector_impl;


typedef union
{
  gsl_const_marray_1_impl  const_base;
  gsl_const_vector_impl    const_impl;
}
gsl_const_vector;

typedef union
{
  gsl_const_marray_1_impl  const_base;
  gsl_const_vector_impl    const_impl;
  gsl_marray_1_impl        base;
  gsl_vector_impl          impl;
}
gsl_vector;



/** Imposters for the old container type. Map the old tags onto the
 *  new structs. Might be used to convert source code to use new
 *  components. Not a complete solution, but perhaps with some
 *  functions to match the old ones, it could be made to work.
 */

typedef struct
{
  const double * data;
  int            rank;
  char           owner;
  char           storage;
  char           packing;
  char           _reserved;
  int            size;
  int            stride;
}
gsl_deprecated_const_vector;

typedef struct
{
  double * data;
  int            rank;
  char           owner;
  char           storage;
  char           packing;
  char           _reserved;
  int            size;
  int            stride;
}
gsl_deprecated_vector;



/** ====================== return-by-value constructors ======================*/

gsl_const_vector
gsl_const_vector_view(const double * d, int size, int stride);

gsl_vector
gsl_vector_view(double * d, int size, int stride);

gsl_vector
gsl_vector_build(int size);



/** ====================== "in-place" destructors =========================== */

void gsl_vector_release_data(gsl_vector * v);



/** ====================== heap constructors ================================ */

gsl_const_vector *
gsl_const_vector_view_new(const double * d, int size, int stride);

gsl_vector *
gsl_vector_view_new(double * d, int size, int stride);

gsl_vector *
gsl_vector_new(int size);



/** ====================== heap destructors ================================ */

void gsl_const_vector_free(gsl_const_vector * v);
void gsl_vector_free(gsl_vector * v);



/** ======================== indexing ===================================== */

int gsl_vector_offset(const gsl_const_vector_impl * v, int index);



/** ======================== slicing ===================================== */

/** Strictly speaking not needed. These are equivalent to the marray_1 functions. */

gsl_vector
gsl_vector_slice(const gsl_vector * v, gsl_marray_idx_slice slice);

gsl_const_vector
gsl_const_vector_slice(const gsl_const_vector * v, gsl_marray_idx_slice slice);



#endif  /* !GSL_VECTOR_H_INCLUDED*/
