/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.axis;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.CallTarget;

public class RunAxisFunctionalTestsTask
extends Task {
    private String tcpServerTarget = null;
    private String httpServerTarget = null;
    private String testTarget;
    private String httpStopTarget = null;
    private URL url = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            this.callStart(this.tcpServerTarget);
            this.callStart(this.httpServerTarget);
            this.callTests();
        }
        finally {
            this.callStop();
        }
    }

    private void callStart(String startTarget) {
        if (startTarget == null) {
            return;
        }
        new Thread(new TaskRunnable(startTarget)).start();
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            try {
                if (startTarget.equals(this.tcpServerTarget)) {
                    this.sendOnSocket("ping\r\n");
                    System.out.println("RunAxisFunctionalTestsTask.callStart successfully pinged tcp server.");
                } else {
                    this.checkHTTPServer();
                    System.out.println("RunAxisFunctionalTestsTask.callStart successfully pinged http server.");
                }
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void callTests() {
        this.antcall(this.testTarget);
    }

    private void callStop() {
        try {
            if (this.tcpServerTarget != null) {
                this.sendOnSocket("quit\r\n");
            }
            if (this.httpServerTarget != null) {
                try {
                    this.checkHTTPServer();
                }
                catch (IOException e) {
                    System.out.println("Error from HTTP read: " + e);
                    return;
                }
            }
            this.antcall(this.httpStopTarget);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new BuildException("Interruption during sleep", (Throwable)e);
            }
            System.out.println("RunAxisFunctionalTestsTask.callStop successfully sent quit message.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void antcall(String taskName) {
        CallTarget callee = (CallTarget)this.getProject().createTask("antcall");
        callee.setOwningTarget(this.getOwningTarget());
        callee.setTaskName(this.getTaskName());
        callee.setLocation(this.getLocation());
        callee.init();
        callee.setTarget(taskName);
        callee.execute();
    }

    private void checkHTTPServer() throws IOException {
        URL url = new URL("http://localhost:8080/");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        RunAxisFunctionalTestsTask.readFully(connection);
        connection.disconnect();
    }

    private void sendOnSocket(String str) throws Exception {
        if (this.url == null) {
            return;
        }
        Socket sock = null;
        sock = new Socket(this.url.getHost(), this.url.getPort());
        sock.getOutputStream().write(new String(str).getBytes());
        int i = sock.getInputStream().read();
    }

    static void readFully(HttpURLConnection connection) throws IOException {
        BufferedInputStream is = new BufferedInputStream(connection.getInputStream());
        byte[] buffer = new byte[256];
        while (is.read(buffer) > 0) {
        }
        is.close();
    }

    public void setTcpServerTarget(String theStartTarget) {
        this.tcpServerTarget = theStartTarget;
    }

    public void setHttpServerTarget(String theStartTarget) {
        this.httpServerTarget = theStartTarget;
    }

    public void setTestTarget(String theTestTarget) {
        this.testTarget = theTestTarget;
    }

    public void setHttpStopTarget(String theStopTarget) {
        this.httpStopTarget = theStopTarget;
    }

    public void setUrl(String theUrl) {
        try {
            this.url = new URL(theUrl);
        }
        catch (MalformedURLException ex) {
            System.err.println("Can't make URL from " + theUrl);
        }
    }

    public class TaskRunnable
    implements Runnable {
        String taskName;

        public TaskRunnable(String taskName) {
            this.taskName = taskName;
        }

        public void run() {
            RunAxisFunctionalTestsTask.this.antcall(this.taskName);
        }
    }
}

