/*
 * This file is licensed under the terms of the Globus Toolkit Public License
 * v3, found at http://www.globus.org/toolkit/legal/4.0/license-v3.html.
 * 
 * This notice must appear in redistributions of this file, with or without
 * modification.
 */
package org.globus.examples.services.security.resource.impl;

import java.net.URL;
import java.rmi.RemoteException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.security.auth.Subject;

import org.globus.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.examples.stubs.Factory.CreateResource;
import org.globus.examples.stubs.Factory.CreateResourceResponse;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.wsrf.Constants;
import org.globus.wsrf.NoResourceHomeException;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.AddressingUtils;

public class MathFactoryService {

	static Log logger = LogFactory.getLog(MathFactoryService.class);

	public CreateResourceResponse createResource(CreateResource request)
			throws RemoteException {

		MathResourceHome home = null;
		ResourceKey key = null;

		/* First, we create a new MathResource through the MathResourceHome */
		try {
			home = (MathResourceHome) getInstanceResourceHome();
			key = home.create();
		} catch (Exception e) {
			throw new RemoteException(e.getMessage(), e);
		}
		EndpointReferenceType epr = null;

		/*
		 * We construct the instance's endpoint reference. The instance's
		 * service path can be found in the JNDI deploy file (as a parameter to
		 * the resource home). This means that we can retrieve it from the
		 * MathResourceHome object.
		 */
		try {
			URL baseURL = ServiceHost.getBaseURL();
			String instanceService = home.getInstanceServicePath();
			String instanceURI = baseURL.toString() + instanceService;
			// The endpoint reference includes the instance's URI and the
			// resource key
			epr = AddressingUtils.createEndpointReference(instanceURI, key);
		} catch (Exception e) {
			throw new RemoteException(e.getMessage(), e);
		}

		/* Finally, return the endpoint reference in a CreateResourceResponse */
		CreateResourceResponse response = new CreateResourceResponse();
		response.setEndpointReference(epr);
		return response;
	}

	protected ResourceHome getInstanceResourceHome()
			throws NoResourceHomeException, ResourceContextException {
		ResourceHome home;
		ResourceContext ctx;

		ctx = ResourceContext.getResourceContext();
		String homeLoc = Constants.JNDI_SERVICES_BASE_NAME + ctx.getService()
				+ "/instanceHome";
		try {
			Context initialContext = new InitialContext();
			home = (ResourceHome) initialContext.lookup(homeLoc);
		} catch (NameNotFoundException e) {
			throw new NoResourceHomeException();
		} catch (NamingException e) {
			throw new ResourceContextException("", e);
		}

		return home;
	}

	private void logSecurityInfo(String methodName) {
		Subject subject;
		logger.info("SECURITY INFO FOR METHOD '" + methodName + "'");

		// Print out the caller
		String identity = SecurityManager.getManager().getCaller();
		logger.info("The caller is:" + identity);

		// Print out the caller's subject
		subject = JaasSubject.getCurrentSubject();
		logger.info("INVOCATION SUBJECT");
		logger.info(subject == null ? "NULL" : subject.toString());

		try {
			// Print out service subject
			logger.info("SERVICE SUBJECT");
			subject = SecurityManager.getManager().getServiceSubject();
			logger.info(subject == null ? "NULL" : subject.toString());
		} catch (Exception e) {
			logger.warn("Unable to obtain service subject");
		}

		try {
			// Print out system subject
			logger.info("SYSTEM SUBJECT");
			subject = SecurityManager.getManager().getSystemSubject();
			logger.info(subject == null ? "NULL" : subject.toString());
		} catch (Exception e) {
			logger.warn("Unable to obtain system subject");
		}
	}

}