/*
 * This file is licensed under the terms of the Globus Toolkit Public License
 * v3, found at http://www.globus.org/toolkit/legal/4.0/license-v3.html.
 * 
 * This notice must appear in redistributions of this file, with or without
 * modification.
 */
package org.globus.examples.services.security.resource.impl;

import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.globus.wsrf.ResourceIdentifier;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.security.SecureResource;

public class MathResource implements SecureResource, ResourceIdentifier,
		ResourceProperties {

	/* Security descriptor */
	ResourceSecurityConfig config;

	/* Resource Property set */
	private ResourcePropertySet propSet;

	/* Resource key. This uniquely identifies this resource. */
	private Object key;

	/* UUID generator to generate unique resource key */
	private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

	/* Resource properties */
	private int value;

	/* Initializes RPs and returns a unique identifier for this resource */
	public Object initialize() throws Exception {
		this.key = uuidGen.nextUUID();
		this.propSet = new SimpleResourcePropertySet(
				MathConstants.RESOURCE_PROPERTIES);

		ResourceProperty valueRP = new ReflectionResourceProperty(
				MathConstants.RP_VALUE, "Value", this);
		this.propSet.add(valueRP);
		setValue(0);

		config = new ResourceSecurityConfig(
				"etc/org_globus_examples_services_security_resource/security-config-resource.xml");
		config.init();

		return key;
	}

	/* Get/Setters for the RPs */
	public int getValue() {
		return value;
	}

	public synchronized void setValue(int value) {
		this.value = value;
	}

	/* Required by interface ResourceProperties */
	public ResourcePropertySet getResourcePropertySet() {
		return this.propSet;
	}

	/* Required by interface ResourceIdentifier */
	public Object getID() {
		return this.key;
	}

	/* Required by SecureResource */
	public ResourceSecurityDescriptor getSecurityDescriptor() {
		return config.getSecurityDescriptor();
	}

}