/*
 * This file is licensed under the terms of the Globus Toolkit Public License
 * v3, found at http://www.globus.org/toolkit/legal/4.0/license-v3.html.
 * 
 * This notice must appear in redistributions of this file, with or without
 * modification.
 */
package org.globus.examples.services.security.resource.impl;

import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.SimpleResourceKey;

public class MathResourceHome extends ResourceHomeImpl {

	private String instanceServicePath;

	public ResourceKey create() throws Exception {
		// Create a resource and initialize it
		MathResource mathResource = (MathResource) this.createNewInstance();
		mathResource.initialize();

		// Get key
		ResourceKey key = new SimpleResourceKey(this.getKeyTypeName(),
				mathResource.getID());

		// Add the resource to the list of resources in this home
		this.add(key, mathResource);
		return key;
	}

	public String getInstanceServicePath() {
		return instanceServicePath;
	}

	public void setInstanceServicePath(String instanceServicePath) {
		this.instanceServicePath = instanceServicePath;
	}
}