/*
 * This file is licensed under the terms of the Globus Toolkit Public License
 * v3, found at http://www.globus.org/toolkit/legal/4.0/license-v3.html.
 * 
 * This notice must appear in redistributions of this file, with or without
 * modification.
 */
package org.globus.examples.services.security.resource.impl;

import java.rmi.RemoteException;

import javax.security.auth.Subject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.examples.stubs.MathService_instance_helloworld.AddResponse;
import org.globus.examples.stubs.MathService_instance_helloworld.HelloWorld;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.security.SecurityManager;

public class MathService {

	static Log logger = LogFactory.getLog(MathService.class);

	/*
	 * Private method that gets a reference to the resource specified in the
	 * endpoint reference.
	 */
	private MathResource getResource() throws RemoteException {
		Object resource = null;
		try {
			resource = ResourceContext.getResourceContext().getResource();
		} catch (NoSuchResourceException e) {
			throw new RemoteException("Specified resource does not exist", e);
		} catch (ResourceContextException e) {
			throw new RemoteException("Error during resource lookup", e);
		} catch (Exception e) {
			throw new RemoteException("", e);
		}

		MathResource mathResource = (MathResource) resource;
		return mathResource;
	}

	/* Implementation of add, subtract, and getValue operations */

	public AddResponse add(int a) throws RemoteException {
		MathResource mathResource = getResource();

		logSecurityInfo("add", mathResource);

		mathResource.setValue(mathResource.getValue() + a);

		return new AddResponse();
	}

	public String helloWorld(HelloWorld params) throws RemoteException {
		logSecurityInfo("helloWorld", null);

		return "Hello, world!";
	}

	private void logSecurityInfo(String methodName, Resource resource) {
		Subject subject;
		logger.info("SECURITY INFO FOR METHOD '" + methodName + "'");

		// Print out the caller
		String identity = SecurityManager.getManager().getCaller();
		logger.info("The caller is:" + identity);

		// Print out the invocation subject
		subject = JaasSubject.getCurrentSubject();
		logger.info("INVOCATION SUBJECT");
		logger.info(subject == null ? "NULL" : subject.toString());

		try {
			// Print out service subject
			logger.info("SERVICE SUBJECT");
			subject = SecurityManager.getManager().getServiceSubject();
			logger.info(subject == null ? "NULL" : subject.toString());
		} catch (Exception e) {
			logger.warn("Unable to obtain service subject");
		}

		try {
			// Print out system subject
			logger.info("SYSTEM SUBJECT");
			subject = SecurityManager.getManager().getSystemSubject();
			logger.info(subject == null ? "NULL" : subject.toString());
		} catch (Exception e) {
			logger.warn("Unable to obtain system subject");
		}

		// Print out resource subject
		logger.info("RESOURCE SUBJECT");
		if (resource == null)
			logger.info("No resource");
		{
			try {
				subject = SecurityManager.getManager().getSubject(resource);
				logger.info(subject == null ? "NULL" : subject.toString());
			} catch (Exception e) {
				logger.warn("Unable to obtain resource subject");
			}
		}
	}

}