/********************************************************
 * Ranges: 255 and 198
 ********************************************************/

#include <gtk/gtk.h>
#include <gdk_magick.h>

#define GDK_MAGICK_FROM_GDK_PIXEL(PIX, M, P, S, D) \
    ((guint16) ((((PIX) & (M)) >> (S)) << ((D) - (P))))
#define GDK_MAGICK_HIGH_QUANTUM(C) \
    ((((guint16) (C)) << 8) + ((guint16) (C)))
#define GDK_MAGICK_LOW_QUANTUM(C) \
    ((guint8) ((C) >> 8))

int main(void) {
  ImageInfo image_info;
  Image *image;
  GdkImage *gdk_image;
  GdkVisual *visual;
  guint32 pixel;
  int i, j;
  guint16 r, g, b;
  gchar *tipos[] = { "GDK_VISUAL_STATIC_GRAY",
		     "GDK_VISUAL_GRAYSCALE",
		     "GDK_VISUAL_STATIC_COLOR",
		     "GDK_VISUAL_PSEUDO_COLOR",
		     "GDK_VISUAL_TRUE_COLOR",
		     "GDK_VISUAL_DIRECT_COLOR" };

  // Initialize 
  gtk_init (NULL, NULL);
  gdk_magick_init (NULL, NULL);

  // Create visual
  visual = gdk_visual_get_system();
  
  if (visual == NULL) {
    g_print("Error en crear el visual\n");
    exit(-1);
  }
  
  // Read image
  GetImageInfo (&image_info);
  strcpy (image_info.filename, "test.gif");
  image = ReadImage (&image_info);
  g_print("Image readed...\n");

  // Convert Image to GdkImage
  gdk_image = gdk_magick_to_gdkimage(image);
  g_print("Image converted...\n");

  // Show pixels values
  g_print("--------------------------------\n");
  g_print("Image Depth: %i\n", gdk_image->depth);
  g_print("Visual Depth: %i\n", visual->depth);
  g_print("Visual Type: %s\n", tipos[visual->type]);
  g_print("Visual Bits Per RGB: %i\n", visual->bits_per_rgb);
  g_print("--------------------------------\n");
    
  // Show pixels values
  for (i = 1; i < gdk_image->height; i++) {
    for (j = 1; j < gdk_image->width; j++) {
      pixel = gdk_image_get_pixel(gdk_image, j, i);
      
      /*
	r = GDK_MAGICK_FROM_GDK_PIXEL(pixel,
	visual->red_mask,
	visual->red_prec,
	visual->red_shift,
	gdk_image->depth);
	g = GDK_MAGICK_FROM_GDK_PIXEL(pixel,
	visual->green_mask,
	visual->green_prec,
	visual->green_shift,
	gdk_image->depth);
	b = GDK_MAGICK_FROM_GDK_PIXEL(pixel,
	visual->blue_mask,
	visual->blue_prec,
	visual->blue_shift,
	gdk_image->depth);
	if (gdk_image->depth < visual->bits_per_rgb) {
	r = GDK_MAGICK_LOW_QUANTUM (r);
	g = GDK_MAGICK_LOW_QUANTUM (g);
	b = GDK_MAGICK_LOW_QUANTUM (b);
	} else if (gdk_image->depth > visual->bits_per_rgb) {
	r = GDK_MAGICK_HIGH_QUANTUM (r);
	g = GDK_MAGICK_HIGH_QUANTUM (g);
	b = GDK_MAGICK_HIGH_QUANTUM (b);
	}
      */
      r = g = b = pixel;
      g_print("(%i,%i,%i)  ", r, g, b);
    }
    g_print("\n");
  }

  return 0;
}
