#include "hdfs.h" 

int main(int argc, char **argv) {

    //hdfsFS fs = hdfsConnect("default", 0);
    hdfsFS fs = hdfsConnect("10.80.32.74", 9000);
    hdfsFS lfs = hdfsConnect(NULL, 0);

    if(!fs) {
        fprintf(stderr, "Oops! Failed to connect to hdfs!\n");
        exit(-1);
    } 
  
    {
        const char* rfile = "/user/arunc/asdfh";
        hdfsFile read_file = hdfsOpenFile(fs, rfile, O_RDONLY, NULL);
        if (!read_file) {
            fprintf(stderr, "Failed to open %s for reading!\n", rfile);
            exit(-1);
        }

        fprintf(stderr, "hdfsAvailable: %d\n", hdfsAvailable(fs, read_file));

        tOffset seekPos = 1;
        if(hdfsSeek(fs, read_file, seekPos)) {
            fprintf(stderr, "Failed to seek %s for reading!\n", rfile);
            exit(-1);
        }

        tOffset currentPos = -1;
        if((currentPos = hdfsTell(fs, read_file)) != seekPos) {
            fprintf(stderr, "Failed to get current file position correctly! Got %d!\n", currentPos);
            exit(-1);
        }
        fprintf(stderr, "Current position: %ld\n", currentPos);

        static char buffer[32];
        tSize num_read_bytes = hdfsRead(fs, read_file, (void*)buffer, sizeof(buffer));
        fprintf(stderr, "Read following %d bytes:\n%s\n", num_read_bytes, buffer);

        hdfsCloseFile(fs, read_file);
    }

    {
        const char* wfile = "/user/arunc/blah.txt";
        hdfsFile write_file = hdfsOpenFile(fs, wfile, O_WRONLY, NULL);
        if(!write_file) {
            fprintf(stderr, "Failed to open %s for writing!\n", wfile);
            exit(-1);
        }
        fprintf(stderr, "Opened %s for writing successfully...\n", wfile);

        char* buffer = "heehaw";
        tSize num_written_bytes = hdfsWrite(fs, write_file, (void*)buffer, strlen(buffer)+1);
        fprintf(stderr, "Wrote %d bytes\n", num_written_bytes);

        tOffset currentPos = -1;
        if ((currentPos = hdfsTell(fs, write_file)) == -1) {
            fprintf(stderr, "Failed to get current file position correctly! Got %d!\n", currentPos);
            exit(-1);
        }
        fprintf(stderr, "Current position: %ld\n", currentPos);

        if (hdfsFlush(fs, write_file)) {
            fprintf(stderr, "Failed to 'flush' %s\n", wfile); 
            exit(-1);
        }
        fprintf(stderr, "Flushed %s successfully!\n", wfile); 

        hdfsCloseFile(fs, write_file);
    }
 
    {
        const char* old_path = "/user/arunc/blah.txt";
        const char* cpy_path = "/user/arunc/blah_cpy.txt";
        const char* mov_path = "/user/arunc/blah_mv.txt";
        const char* new_path = "/user/arunc/blahnew.txt";

        fprintf(stderr, "hdfsCopy: %s\n", (hdfsCopy(fs, old_path, fs, cpy_path) ? "Failed!" : "Success!"));

        fprintf(stderr, "hdfsMove: %s\n", (hdfsMove(fs, cpy_path, fs, mov_path) ? "Failed!" : "Success!"));

        fprintf(stderr, "hdfsRename: %s\n", (hdfsRename(fs, old_path, new_path) ? "Failed!" : "Success!"));

        fprintf(stderr, "hdfsLock: %s\n", (hdfsLock(fs, new_path, 1) ? "Failed!" : "Success!"));
        fprintf(stderr, "hdfsReleaseLock: %s\n", (hdfsReleaseLock(fs, new_path) ? "Failed!" : "Success!"));

        fprintf(stderr, "hdfsDelete: %s\n", (hdfsDelete(fs, new_path) ? "Failed!" : "Success!"));

        const char* new_dir = "/user/arunc/newdir2";
        fprintf(stderr, "hdfsCreateDirectory: %s\n", (hdfsCreateDirectory(fs, new_dir) ? "Failed!" : "Success!"));

        char buffer[256];
        fprintf(stderr, "hdfsGetWorkingDirectory: %s\n", (hdfsGetWorkingDirectory(fs, buffer, sizeof(buffer)) ? buffer : "Failed!"));
        /*    fprintf(stderr, "hdfsSetWorkingDirectory: %s\n", (hdfsSetWorkingDirectory(fs, new_dir) ? "Failed!" : "Success!"));*/
        /*    fprintf(stderr, "hdfsGetWorkingDirectory: %s\n", (hdfsGetWorkingDirectory(fs, buffer, sizeof(buffer)) ? buffer : "Failed!"));*/

        fprintf(stderr, "hdfsGetBlockSize: %Ld\n", hdfsGetBlockSize(fs));
        fprintf(stderr, "hdfsGetCapacity: %Ld\n", hdfsGetCapacity(fs));
        fprintf(stderr, "hdfsGetUsed: %Ld\n", hdfsGetUsed(fs));

        hdfsFileInfo *fileInfo = NULL;
        if(fileInfo = hdfsGetPathInfo(fs, "newdir")) {
            fprintf(stderr, "Yaay! hdfsGetPathInfo - SUCCESS!\n");
            fprintf(stderr, "Name: %s,", fileInfo->mName);
            fprintf(stderr, "Type: %c,", (char)fileInfo->mKind);
            fprintf(stderr, "Size: %ld\n", fileInfo->mSize);
            hdfsFreeFileInfo(fileInfo, 1);
        } else {
            fprintf(stderr, "waah! hdfsGetPathInfo - FAILED!\n");
        }

        hdfsFileInfo *fileList = 0;
        int numEntries = 0;
        if(fileList = hdfsListDirectory(fs, "/user/arunc", &numEntries)) {
            int i = 0;
            for(i=0; i < numEntries; ++i) {
                fprintf(stderr, "Name: %s,", fileList[i].mName);
                fprintf(stderr, "Type: %c,", (char)fileList[i].mKind);
                fprintf(stderr, "Size: %ld\n", fileList[i].mSize);
            }
            hdfsFreeFileInfo(fileList, numEntries);
        } else {
            fprintf(stderr, "waah! hdfsListDirectory - FAILED!\n");
        }

        char*** hosts = hdfsGetHosts(fs, "/user/arunc/asdfh", 0, 1);
        if(hosts) {
            fprintf(stderr, "hdfsGetHosts - SUCCESS! ... \n");
            int i=0; 
            while(hosts[i]) {
                int j = 0;
                while(hosts[i][j]) {
                    fprintf(stderr, 
                            "\thosts[%d][%d] - %s\n", i, j, hosts[i][j]);
                    ++j;
                }
                ++i;
            }
        } else {
            fprintf(stderr, "waah! hdfsGetHosts - FAILED!\n");
        }
    }


    return 0;
}

/**
 * vim: ts=4: sw=4: et:
 */

