/*
* Copyright (c) 2012 Nathanael Hübbe
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
* SUCH DAMAGE.
*/

#include <hdf5.h>

#define testPrivateData ((void*)(0x0001020304050607l))

const char* H5_XM_get_module_name(void) {
	printf("H5_XM_get_module_name() called.\n");
	return "Test module";
}

herr_t H5_XM_get_module_version(int* majorVersion, int* minorVersion, int* releaseNumber) {
	printf("H5_XM_get_module_version() called.\n");
	*majorVersion = 0;
	*minorVersion = 1;
	*releaseNumber = 2;
	return 0;	//SUCCEED is not defined publicly?!?
}

herr_t H5_XM_init(void** privateData) {
	*privateData = testPrivateData;
	printf("Test module initialized.\n");
	return 0;	//SUCCEED is not defined publicly?!?
}

herr_t H5_XM_deinit(void* privateData) {
	if(privateData == testPrivateData) {
		printf("Test module successfully destructed.\n");
		return 0;	//SUCCEED is not defined publicly?!?
	} else {
		printf("Test module incorrectly destructed. Wrong private data passed in.\n");
		return -1;	//FAIL is not defined publicly?!?
	}
}
