#include <glpk.h>
#include <iostream>
#include <fstream>
#include <regex>
#include <stdio.h>
#include <cstring>
#include <stdlib.h>

#define rowNum 17
#define colNum 10
static double epsilon = 0.1 ;

int main() {
  std::ifstream ifs("./glpk_matrix.txt");
  std::regex pattern("[[:space:]]") ;
  std::string line ;
  std::vector<std::string> strToken ;
  while( std::getline(ifs, line) ) {
    char* curr = strdup(line.c_str()) ;
    char *token = std::strtok(curr, ", ");
    while (token != NULL) {
      strToken.push_back(token) ;
      token = std::strtok(NULL, " ");
    } 
  }

  double matrix[rowNum][colNum] ;
  double num, den ;
  for (int i = 0; i < rowNum; ++ i) {
    for (int j = 0; j < colNum; ++ j) {
      std::string currStr = strToken.at(i*colNum+j) ;
      auto pos = currStr.find("/") ;
      if (pos != currStr.npos) {
        num = std::atof( currStr.substr(0, pos).c_str() ) ;
        den = std::atof( currStr.substr(pos+1).c_str() ) ;
        matrix[i][j] = num / den ;
      }
      else {
        matrix[i][j] = std::atof( currStr.c_str() ) ;
      }
    }
  }
  
  int idx1[] = {0,1,2,3,4,8,9,11,12,15} ;
  int idx2[] = {5,7,13,14} ;
  int idx3[] = {16} ;
  int idx4[] = {6,10} ;

  glp_prob* glp = glp_create_prob() ;
  
  int idxj[colNum] ;
  double vals[colNum] ;
  glp_set_obj_dir(glp, GLP_MIN) ;
  glp_add_cols(glp, colNum-1) ;
  for(int j = 1; j < colNum; ++ j) {
    glp_set_col_bnds(glp, j, GLP_FR, 0.0, 0.0) ;
  }
  glp_set_obj_coef(glp, 1, 0.0) ; 

  int size ;
  int* currIdx ;
  for (int p = 0; p < 4; ++ p) {
    switch (p) {
      case 0 : currIdx = idx1 ; size = 10 ; break ; 
      case 1 : currIdx = idx2 ; size = 4 ; break ;
      case 2 : currIdx = idx3 ; size = 1 ; break ;
      case 3 : currIdx = idx4 ; size = 2 ; break ;
      default : break ;
    }

    int oriRow = glp_get_num_rows(glp) ;

    glp_add_rows(glp, size) ;
    double constant ;
    for(int i = 0; i < size; ++ i) {
      constant = matrix[ currIdx[i] ][colNum-1] ;
      if (oriRow + i == 0) {
        glp_set_row_bnds(glp, 1, GLP_LO, constant+epsilon, 0.0) ;
      }
      else {
        glp_set_row_bnds(glp, oriRow+i+1, GLP_UP, 0.0, constant-epsilon) ;
      }
    }

    for(int i = 0; i < size; ++ i) {
      for(int j = 0; j < colNum-1; ++ j) {
        idxj[j+1] = j + 1 ;
        vals[j+1] = -matrix[ currIdx[i] ][j] ;
      }
      glp_set_mat_row(glp, oriRow+i+1, colNum-1, idxj, vals) ;
    }

    glp_smcp para ;
    glp_init_smcp(&para) ;
    //para.msg_lev = GLP_MSG_OFF ;
    para.meth = GLP_DUAL ;

    //glp_write_lp(glp, NULL, "test.lp") ;

    glp_simplex(glp, &para) ;
  }

  return 0 ;
}
