#include <Foundation/Foundation.h>

@interface Say: NSObject
{
  NSURL *url;
  BOOL shouldStop;
}

- (BOOL) shouldStop;
- (void) URLResourceDidFinishLoading: (NSURL *) sender;
@end

@implementation Say

- (id) init
{
  self = [super init];
  shouldStop = NO;
  url = [[NSURL alloc] initWithString: @"http://www.macnn.com/macnn.xml"];
  [url loadResourceDataNotifyingClient: self usingCache: NO];
  NSLog(@"Start non-blocking");
  return self;
}

- (void) URLResourceDidFinishLoading: (NSURL *) sender
{
  NSLog(@"URLHandleResourceDidBeginLoading: %@", sender);
  shouldStop = YES;
}

- (BOOL) shouldStop
{
  return shouldStop;
}

@end

int main (void)
{
   id speaker;
   NSAutoreleasePool *pool;

   pool = [NSAutoreleasePool new];
   speaker = [[Say alloc] init];

   while([speaker shouldStop] == NO) 
    {
    }

   RELEASE(speaker);
   RELEASE(pool);
}
