//Defines a few helpful functions that didn't seem to be readily
//classified anywhere else.

#ifndef __UTILS_HPP__ 
#define __UTILS_HPP__

#include "linalg.hpp"

#include <string>
#include <map>
#include <set>


namespace utils{
  //Clears whitespace from front and back of string s.
  std::string trim(const std::string& s);

  //Does map or set contain given thing?
  template<typename K, typename V> 
  bool contains(const std::map<K,V>& m, K thing);
  template<typename E>
  bool contains(const std::set<E>& s, E thing);

  //Is set s1 a subset of set s2?
  template<typename E>
  bool includes(const std::set<E>& s1, const std::set<E>& s2);

  //Reads matrices and vectors from filenames.
  linalg::matrix read_matrix(std::string filename);
  linalg::vector read_vector(std::string filename);

  //Reads map<point,double> from a matrix. Last column is the value at
  //each point which is represented in turn by the rest of the row.
  
  std::map<linalg::point, double> read_pd_map(std::string filename);

  //Outputs some information about generic exceptions.
  void show_exception(error_handling::error exc);

}

#endif
