#include "include/linalg.hpp"
#include "include/error.hpp"
#include "include/utils.hpp"

#include <iostream>
#include <fstream>

int main(){
  try{ //Catch all exceptions in main()
    using namespace std;
    linalg::vector v, u; 
    linalg::matrix M, N;

    //Read a vector from file.
    ifstream ifs("v.vec");
    ifs >> v;
    ifs.close();
  
    //Read a matrix from file
    ifs.open("M.mtx");
    ifs >> M;

    //Can also read them this way:
    u = utils::read_vector("u.vec");
    N = utils::read_matrix("N.mtx");
    
    //Output some results computations:
    cout << "This M*v:         " << M*v << endl
	 << "This is M\\v:     " << M.inv(v) << endl
	 << "This is <u|v>:    " << u*v << endl
	 << "This is (M*N)\\v: " << (M*N).inv(v) << endl;
  }

  //If there were problems, tell us about them.
  catch(error_handling::error exc){ 
    utils::show_exception(exc);
  }
}
